/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourceTrello - The values required to configure the source.
 */

public class SourceTrello {
    /**
     * IDs of the boards to replicate data from. If left empty, data from all boards to which you have access will be replicated.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("board_ids")
    public String[] boardIds;

    public SourceTrello withBoardIds(String[] boardIds) {
        this.boardIds = boardIds;
        return this;
    }
    
    /**
     * Trello API key. See the &lt;a href="https://developer.atlassian.com/cloud/trello/guides/rest-api/authorization/#using-basic-oauth"&gt;docs&lt;/a&gt; for instructions on how to generate it.
     */
    @JsonProperty("key")
    public String key;

    public SourceTrello withKey(String key) {
        this.key = key;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourceTrelloTrello sourceType;

    public SourceTrello withSourceType(SourceTrelloTrello sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * UTC date and time in the format 2017-01-25T00:00:00Z. Any data before this date will not be replicated.
     */
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourceTrello withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    /**
     * Trello API token. See the &lt;a href="https://developer.atlassian.com/cloud/trello/guides/rest-api/authorization/#using-basic-oauth"&gt;docs&lt;/a&gt; for instructions on how to generate it.
     */
    @JsonProperty("token")
    public String token;

    public SourceTrello withToken(String token) {
        this.token = token;
        return this;
    }
    
    public SourceTrello(@JsonProperty("key") String key, @JsonProperty("sourceType") SourceTrelloTrello sourceType, @JsonProperty("start_date") OffsetDateTime startDate, @JsonProperty("token") String token) {
        this.key = key;
        this.sourceType = sourceType;
        this.startDate = startDate;
        this.token = token;
  }
}
