/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api;

import com.airbyte.api.Connections;
import com.airbyte.api.Destinations;
import com.airbyte.api.Jobs;
import com.airbyte.api.SDKConfiguration;
import com.airbyte.api.Sources;
import com.airbyte.api.Streams;
import com.airbyte.api.Workspaces;
import com.airbyte.api.models.shared.Security;
import com.airbyte.api.utils.HTTPClient;
import com.airbyte.api.utils.SpeakeasyHTTPClient;
import com.airbyte.api.utils.Utils;
import java.util.Map;

public class Airbyte {
    public static final String[] SERVERS = new String[]{"https://api.airbyte.com/v1"};
    public Connections connections;
    public Destinations destinations;
    public Jobs jobs;
    public Sources sources;
    public Streams streams;
    public Workspaces workspaces;
    private SDKConfiguration sdkConfiguration;

    public static Builder builder() {
        return new Builder();
    }

    private Airbyte(SDKConfiguration sdkConfiguration) throws Exception {
        this.sdkConfiguration = sdkConfiguration;
        this.connections = new Connections(this.sdkConfiguration);
        this.destinations = new Destinations(this.sdkConfiguration);
        this.jobs = new Jobs(this.sdkConfiguration);
        this.sources = new Sources(this.sdkConfiguration);
        this.streams = new Streams(this.sdkConfiguration);
        this.workspaces = new Workspaces(this.sdkConfiguration);
    }

    public static class Builder {
        private SDKConfiguration sdkConfiguration = new SDKConfiguration();

        private Builder() {
        }

        public Builder setClient(HTTPClient client) {
            this.sdkConfiguration.defaultClient = client;
            return this;
        }

        public Builder setSecurity(Security security) {
            this.sdkConfiguration.security = security;
            return this;
        }

        public Builder setServerURL(String serverUrl) {
            this.sdkConfiguration.serverUrl = serverUrl;
            return this;
        }

        public Builder setServerURL(String serverUrl, Map<String, String> params) {
            this.sdkConfiguration.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }

        public Builder setServerIndex(int serverIdx) {
            this.sdkConfiguration.serverIdx = serverIdx;
            this.sdkConfiguration.serverUrl = SERVERS[serverIdx];
            return this;
        }

        public Airbyte build() throws Exception {
            if (this.sdkConfiguration.defaultClient == null) {
                this.sdkConfiguration.defaultClient = new SpeakeasyHTTPClient();
            }
            if (this.sdkConfiguration.security != null) {
                this.sdkConfiguration.securityClient = Utils.configureSecurityClient(this.sdkConfiguration.defaultClient, this.sdkConfiguration.security);
            }
            if (this.sdkConfiguration.securityClient == null) {
                this.sdkConfiguration.securityClient = this.sdkConfiguration.defaultClient;
            }
            if (this.sdkConfiguration.serverUrl == null || this.sdkConfiguration.serverUrl.isBlank()) {
                this.sdkConfiguration.serverUrl = SERVERS[0];
                this.sdkConfiguration.serverIdx = 0;
            }
            if (this.sdkConfiguration.serverUrl.endsWith("/")) {
                this.sdkConfiguration.serverUrl = this.sdkConfiguration.serverUrl.substring(0, this.sdkConfiguration.serverUrl.length() - 1);
            }
            return new Airbyte(this.sdkConfiguration);
        }
    }
}

