/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api;

import com.airbyte.api.SDKConfiguration;
import com.airbyte.api.models.operations.CreateConnectionResponse;
import com.airbyte.api.models.operations.DeleteConnectionRequest;
import com.airbyte.api.models.operations.DeleteConnectionResponse;
import com.airbyte.api.models.operations.GetConnectionRequest;
import com.airbyte.api.models.operations.GetConnectionResponse;
import com.airbyte.api.models.operations.ListConnectionsRequest;
import com.airbyte.api.models.operations.ListConnectionsResponse;
import com.airbyte.api.models.operations.PatchConnectionRequest;
import com.airbyte.api.models.operations.PatchConnectionResponse;
import com.airbyte.api.models.shared.ConnectionCreateRequest;
import com.airbyte.api.models.shared.ConnectionResponse;
import com.airbyte.api.models.shared.ConnectionsResponse;
import com.airbyte.api.utils.HTTPClient;
import com.airbyte.api.utils.HTTPRequest;
import com.airbyte.api.utils.JSON;
import com.airbyte.api.utils.SerializedBody;
import com.airbyte.api.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.NameValuePair;

public class Connections {
    private SDKConfiguration sdkConfiguration;

    public Connections(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateConnectionResponse createConnection(ConnectionCreateRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/connections");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("POST");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "request", "json");
        if (serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateConnectionResponse res = new CreateConnectionResponse(contentType, httpRes.statusCode()){
            {
                this.connectionResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                ConnectionResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.connectionResponse = out = (ConnectionResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), ConnectionResponse.class);
            }
        } else if (httpRes.statusCode() == 400 || httpRes.statusCode() == 403) {
            // empty if block
        }
        return res;
    }

    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(DeleteConnectionRequest.class, baseUrl, "/connections/{connectionId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("DELETE");
        req.setURL(url);
        req.addHeader("Accept", "*/*");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        DeleteConnectionResponse res = new DeleteConnectionResponse(contentType, httpRes.statusCode()){};
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 204 || httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public GetConnectionResponse getConnection(GetConnectionRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(GetConnectionRequest.class, baseUrl, "/connections/{connectionId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetConnectionResponse res = new GetConnectionResponse(contentType, httpRes.statusCode()){
            {
                this.connectionResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                ConnectionResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.connectionResponse = out = (ConnectionResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), ConnectionResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public ListConnectionsResponse listConnections(ListConnectionsRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/connections");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        List<NameValuePair> queryParams = Utils.getQueryParams(ListConnectionsRequest.class, request, null);
        if (queryParams != null) {
            for (NameValuePair queryParam : queryParams) {
                req.addQueryParam(queryParam);
            }
        }
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        ListConnectionsResponse res = new ListConnectionsResponse(contentType, httpRes.statusCode()){
            {
                this.connectionsResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                ConnectionsResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.connectionsResponse = out = (ConnectionsResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), ConnectionsResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public PatchConnectionResponse patchConnection(PatchConnectionRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(PatchConnectionRequest.class, baseUrl, "/connections/{connectionId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("PATCH");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "connectionPatchRequest", "json");
        if (serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        PatchConnectionResponse res = new PatchConnectionResponse(contentType, httpRes.statusCode()){
            {
                this.connectionResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                ConnectionResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.connectionResponse = out = (ConnectionResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), ConnectionResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }
}

