/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api;

import com.airbyte.api.SDKConfiguration;
import com.airbyte.api.models.operations.CreateDestinationResponse;
import com.airbyte.api.models.operations.DeleteDestinationRequest;
import com.airbyte.api.models.operations.DeleteDestinationResponse;
import com.airbyte.api.models.operations.GetDestinationRequest;
import com.airbyte.api.models.operations.GetDestinationResponse;
import com.airbyte.api.models.operations.ListDestinationsRequest;
import com.airbyte.api.models.operations.ListDestinationsResponse;
import com.airbyte.api.models.operations.PatchDestinationRequest;
import com.airbyte.api.models.operations.PatchDestinationResponse;
import com.airbyte.api.models.operations.PutDestinationRequest;
import com.airbyte.api.models.operations.PutDestinationResponse;
import com.airbyte.api.models.shared.DestinationCreateRequest;
import com.airbyte.api.models.shared.DestinationResponse;
import com.airbyte.api.models.shared.DestinationsResponse;
import com.airbyte.api.utils.HTTPClient;
import com.airbyte.api.utils.HTTPRequest;
import com.airbyte.api.utils.JSON;
import com.airbyte.api.utils.SerializedBody;
import com.airbyte.api.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.NameValuePair;

public class Destinations {
    private SDKConfiguration sdkConfiguration;

    public Destinations(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateDestinationResponse createDestination(DestinationCreateRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/destinations");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("POST");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "request", "json");
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateDestinationResponse res = new CreateDestinationResponse(contentType, httpRes.statusCode()){
            {
                this.destinationResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                DestinationResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.destinationResponse = out = (DestinationResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), DestinationResponse.class);
            }
        } else if (httpRes.statusCode() == 400 || httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public DeleteDestinationResponse deleteDestination(DeleteDestinationRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(DeleteDestinationRequest.class, baseUrl, "/destinations/{destinationId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("DELETE");
        req.setURL(url);
        req.addHeader("Accept", "*/*");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        DeleteDestinationResponse res = new DeleteDestinationResponse(contentType, httpRes.statusCode()){};
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 204 || httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public GetDestinationResponse getDestination(GetDestinationRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(GetDestinationRequest.class, baseUrl, "/destinations/{destinationId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetDestinationResponse res = new GetDestinationResponse(contentType, httpRes.statusCode()){
            {
                this.destinationResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                DestinationResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.destinationResponse = out = (DestinationResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), DestinationResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public ListDestinationsResponse listDestinations(ListDestinationsRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/destinations");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        List<NameValuePair> queryParams = Utils.getQueryParams(ListDestinationsRequest.class, request, null);
        if (queryParams != null) {
            for (NameValuePair queryParam : queryParams) {
                req.addQueryParam(queryParam);
            }
        }
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        ListDestinationsResponse res = new ListDestinationsResponse(contentType, httpRes.statusCode()){
            {
                this.destinationsResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                DestinationsResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.destinationsResponse = out = (DestinationsResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), DestinationsResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public PatchDestinationResponse patchDestination(PatchDestinationRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(PatchDestinationRequest.class, baseUrl, "/destinations/{destinationId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("PATCH");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "destinationPatchRequest", "json");
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        PatchDestinationResponse res = new PatchDestinationResponse(contentType, httpRes.statusCode()){
            {
                this.destinationResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                DestinationResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.destinationResponse = out = (DestinationResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), DestinationResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public PutDestinationResponse putDestination(PutDestinationRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(PutDestinationRequest.class, baseUrl, "/destinations/{destinationId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("PUT");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "destinationPutRequest", "json");
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        PutDestinationResponse res = new PutDestinationResponse(contentType, httpRes.statusCode()){
            {
                this.destinationResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                DestinationResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.destinationResponse = out = (DestinationResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), DestinationResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }
}

