/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api;

import com.airbyte.api.SDKConfiguration;
import com.airbyte.api.models.operations.CancelJobRequest;
import com.airbyte.api.models.operations.CancelJobResponse;
import com.airbyte.api.models.operations.CreateJobResponse;
import com.airbyte.api.models.operations.GetJobRequest;
import com.airbyte.api.models.operations.GetJobResponse;
import com.airbyte.api.models.operations.ListJobsRequest;
import com.airbyte.api.models.operations.ListJobsResponse;
import com.airbyte.api.models.shared.JobCreateRequest;
import com.airbyte.api.models.shared.JobResponse;
import com.airbyte.api.models.shared.JobsResponse;
import com.airbyte.api.utils.HTTPClient;
import com.airbyte.api.utils.HTTPRequest;
import com.airbyte.api.utils.JSON;
import com.airbyte.api.utils.SerializedBody;
import com.airbyte.api.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.NameValuePair;

public class Jobs {
    private SDKConfiguration sdkConfiguration;

    public Jobs(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CancelJobResponse cancelJob(CancelJobRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(CancelJobRequest.class, baseUrl, "/jobs/{jobId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("DELETE");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CancelJobResponse res = new CancelJobResponse(contentType, httpRes.statusCode()){
            {
                this.jobResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                JobResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.jobResponse = out = (JobResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), JobResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public CreateJobResponse createJob(JobCreateRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/jobs");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("POST");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "request", "json");
        if (serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateJobResponse res = new CreateJobResponse(contentType, httpRes.statusCode()){
            {
                this.jobResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                JobResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.jobResponse = out = (JobResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), JobResponse.class);
            }
        } else if (httpRes.statusCode() == 400 || httpRes.statusCode() == 403) {
            // empty if block
        }
        return res;
    }

    public GetJobResponse getJob(GetJobRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(GetJobRequest.class, baseUrl, "/jobs/{jobId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetJobResponse res = new GetJobResponse(contentType, httpRes.statusCode()){
            {
                this.jobResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                JobResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.jobResponse = out = (JobResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), JobResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public ListJobsResponse listJobs(ListJobsRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/jobs");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        List<NameValuePair> queryParams = Utils.getQueryParams(ListJobsRequest.class, request, null);
        if (queryParams != null) {
            for (NameValuePair queryParam : queryParams) {
                req.addQueryParam(queryParam);
            }
        }
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        ListJobsResponse res = new ListJobsResponse(contentType, httpRes.statusCode()){
            {
                this.jobsResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                JobsResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.jobsResponse = out = (JobsResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), JobsResponse.class);
            }
        } else if (httpRes.statusCode() == 403) {
            // empty if block
        }
        return res;
    }
}

