/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api;

import com.airbyte.api.SDKConfiguration;
import com.airbyte.api.models.operations.CreateSourceResponse;
import com.airbyte.api.models.operations.DeleteSourceRequest;
import com.airbyte.api.models.operations.DeleteSourceResponse;
import com.airbyte.api.models.operations.GetSourceRequest;
import com.airbyte.api.models.operations.GetSourceResponse;
import com.airbyte.api.models.operations.InitiateOAuthResponse;
import com.airbyte.api.models.operations.ListSourcesRequest;
import com.airbyte.api.models.operations.ListSourcesResponse;
import com.airbyte.api.models.operations.PatchSourceRequest;
import com.airbyte.api.models.operations.PatchSourceResponse;
import com.airbyte.api.models.operations.PutSourceRequest;
import com.airbyte.api.models.operations.PutSourceResponse;
import com.airbyte.api.models.shared.InitiateOauthRequest;
import com.airbyte.api.models.shared.SourceCreateRequest;
import com.airbyte.api.models.shared.SourceResponse;
import com.airbyte.api.models.shared.SourcesResponse;
import com.airbyte.api.utils.HTTPClient;
import com.airbyte.api.utils.HTTPRequest;
import com.airbyte.api.utils.JSON;
import com.airbyte.api.utils.SerializedBody;
import com.airbyte.api.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.NameValuePair;

public class Sources {
    private SDKConfiguration sdkConfiguration;

    public Sources(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateSourceResponse createSource(SourceCreateRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/sources");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("POST");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "request", "json");
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateSourceResponse res = new CreateSourceResponse(contentType, httpRes.statusCode()){
            {
                this.sourceResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                SourceResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.sourceResponse = out = (SourceResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), SourceResponse.class);
            }
        } else if (httpRes.statusCode() == 400 || httpRes.statusCode() == 403) {
            // empty if block
        }
        return res;
    }

    public DeleteSourceResponse deleteSource(DeleteSourceRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(DeleteSourceRequest.class, baseUrl, "/sources/{sourceId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("DELETE");
        req.setURL(url);
        req.addHeader("Accept", "*/*");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        DeleteSourceResponse res = new DeleteSourceResponse(contentType, httpRes.statusCode()){};
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 204 || httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public GetSourceResponse getSource(GetSourceRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(GetSourceRequest.class, baseUrl, "/sources/{sourceId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetSourceResponse res = new GetSourceResponse(contentType, httpRes.statusCode()){
            {
                this.sourceResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                SourceResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.sourceResponse = out = (SourceResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), SourceResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public InitiateOAuthResponse initiateOAuth(InitiateOauthRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/sources/initiateOAuth");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("POST");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "request", "json");
        if (serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "*/*");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        InitiateOAuthResponse res = new InitiateOAuthResponse(contentType, httpRes.statusCode()){};
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200 || httpRes.statusCode() == 400 || httpRes.statusCode() == 403) {
            // empty if block
        }
        return res;
    }

    public ListSourcesResponse listSources(ListSourcesRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/sources");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        List<NameValuePair> queryParams = Utils.getQueryParams(ListSourcesRequest.class, request, null);
        if (queryParams != null) {
            for (NameValuePair queryParam : queryParams) {
                req.addQueryParam(queryParam);
            }
        }
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        ListSourcesResponse res = new ListSourcesResponse(contentType, httpRes.statusCode()){
            {
                this.sourcesResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                SourcesResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.sourcesResponse = out = (SourcesResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), SourcesResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public PatchSourceResponse patchSource(PatchSourceRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(PatchSourceRequest.class, baseUrl, "/sources/{sourceId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("PATCH");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "sourcePatchRequest", "json");
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        PatchSourceResponse res = new PatchSourceResponse(contentType, httpRes.statusCode()){
            {
                this.sourceResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                SourceResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.sourceResponse = out = (SourceResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), SourceResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }

    public PutSourceResponse putSource(PutSourceRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(PutSourceRequest.class, baseUrl, "/sources/{sourceId}", request, null);
        HTTPRequest req = new HTTPRequest();
        req.setMethod("PUT");
        req.setURL(url);
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(request, "sourcePutRequest", "json");
        req.setBody(serializedRequestBody);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        PutSourceResponse res = new PutSourceResponse(contentType, httpRes.statusCode()){
            {
                this.sourceResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                SourceResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.sourceResponse = out = (SourceResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), SourceResponse.class);
            }
        } else if (httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }
}

