/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api;

import com.airbyte.api.SDKConfiguration;
import com.airbyte.api.models.operations.GetStreamPropertiesRequest;
import com.airbyte.api.models.operations.GetStreamPropertiesResponse;
import com.airbyte.api.models.shared.StreamPropertiesResponse;
import com.airbyte.api.utils.HTTPClient;
import com.airbyte.api.utils.HTTPRequest;
import com.airbyte.api.utils.JSON;
import com.airbyte.api.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.NameValuePair;

public class Streams {
    private SDKConfiguration sdkConfiguration;

    public Streams(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetStreamPropertiesResponse getStreamProperties(GetStreamPropertiesRequest request) throws Exception {
        String baseUrl = this.sdkConfiguration.serverUrl;
        String url = Utils.generateURL(baseUrl, "/streams");
        HTTPRequest req = new HTTPRequest();
        req.setMethod("GET");
        req.setURL(url);
        req.addHeader("Accept", "application/json");
        req.addHeader("user-agent", String.format("speakeasy-sdk/%s %s %s %s", this.sdkConfiguration.language, this.sdkConfiguration.sdkVersion, this.sdkConfiguration.genVersion, this.sdkConfiguration.openapiDocVersion));
        List<NameValuePair> queryParams = Utils.getQueryParams(GetStreamPropertiesRequest.class, request, null);
        if (queryParams != null) {
            for (NameValuePair queryParam : queryParams) {
                req.addQueryParam(queryParam);
            }
        }
        HTTPClient client = this.sdkConfiguration.securityClient;
        HttpResponse<byte[]> httpRes = client.send(req);
        String contentType = httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetStreamPropertiesResponse res = new GetStreamPropertiesResponse(contentType, httpRes.statusCode()){
            {
                this.streamPropertiesResponse = null;
            }
        };
        res.rawResponse = httpRes;
        if (httpRes.statusCode() == 200) {
            if (Utils.matchContentType(contentType, "application/json")) {
                StreamPropertiesResponse out;
                ObjectMapper mapper = JSON.getMapper();
                res.streamPropertiesResponse = out = (StreamPropertiesResponse)mapper.readValue(new String(httpRes.body(), StandardCharsets.UTF_8), StreamPropertiesResponse.class);
            }
        } else if (httpRes.statusCode() == 400 || httpRes.statusCode() == 403 || httpRes.statusCode() == 404) {
            // empty if block
        }
        return res;
    }
}

