/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api.utils;

import com.airbyte.api.utils.SpeakeasyMetadata;
import java.lang.reflect.Field;
import java.util.HashMap;

public class Metadata {
    protected static Object parse(String name, Object metadata, Field field) throws IllegalArgumentException, IllegalAccessException {
        SpeakeasyMetadata md = field.getAnnotation(SpeakeasyMetadata.class);
        if (md == null) {
            return null;
        }
        String mdValue = md.value();
        if (mdValue == null || mdValue.isBlank()) {
            return null;
        }
        String[] groups = mdValue.split(" ");
        boolean handled = false;
        for (String group : groups) {
            Field[] fields;
            String[] pairs;
            String[] parts = group.split(":");
            if (parts.length != 2) {
                return null;
            }
            if (!parts[0].equals(name)) continue;
            HashMap<String, String> values = new HashMap<String, String>();
            for (String pair : pairs = parts[1].split(",")) {
                String[] keyVal = pair.split("=");
                String key = keyVal[0];
                String val = "";
                if (keyVal.length > 1) {
                    val = keyVal[1];
                }
                values.put(key, val);
            }
            for (Field f : fields = metadata.getClass().getFields()) {
                f.setAccessible(true);
                if (!values.containsKey(f.getName())) continue;
                String val = (String)values.get(f.getName());
                if (f.getType().equals(Boolean.TYPE) || f.getType().equals(Boolean.class)) {
                    f.set(metadata, val.equals("true") || val.isBlank());
                    continue;
                }
                f.set(metadata, val);
            }
            handled = true;
        }
        if (!handled) {
            return null;
        }
        return metadata;
    }
}

