/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api.utils;

import com.airbyte.api.utils.JSON;
import com.airbyte.api.utils.QueryParamsMetadata;
import com.airbyte.api.utils.Types;
import com.airbyte.api.utils.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class QueryParameters {
    public static <T> List<NameValuePair> parseQueryParams(Class<T> type, T queryParams, Map<String, Map<String, Map<String, Object>>> globals) throws Exception {
        Field[] fields;
        ArrayList<NameValuePair> allParams = new ArrayList<NameValuePair>();
        block10: for (Field field : fields = type.getFields()) {
            QueryParamsMetadata queryParamsMetadata;
            Object value = queryParams != null ? field.get(queryParams) : null;
            if ((value = Utils.populateGlobal(value, field.getName(), "queryParam", globals)) == null || (queryParamsMetadata = QueryParamsMetadata.parse(field)) == null) continue;
            if (queryParamsMetadata.serialization != null && !queryParamsMetadata.serialization.isBlank()) {
                List<NameValuePair> params = QueryParameters.parseSerializedParams(queryParamsMetadata, value);
                allParams.addAll(params);
                continue;
            }
            switch (queryParamsMetadata.style) {
                case "form": {
                    List<NameValuePair> formParams = QueryParameters.parseDelimitedParams(queryParamsMetadata, value, ",");
                    allParams.addAll(formParams);
                    continue block10;
                }
                case "deepObject": {
                    List<NameValuePair> deepObjectParams = QueryParameters.parseDeepObjectParams(queryParamsMetadata, value);
                    allParams.addAll(deepObjectParams);
                    continue block10;
                }
                case "pipeDelimited": {
                    List<NameValuePair> pipeDelimitedParams = QueryParameters.parseDelimitedParams(queryParamsMetadata, value, "|");
                    allParams.addAll(pipeDelimitedParams);
                }
            }
        }
        return allParams;
    }

    private static List<NameValuePair> parseSerializedParams(QueryParamsMetadata queryParamsMetadata, Object value) throws JsonProcessingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        switch (queryParamsMetadata.serialization) {
            case "json": {
                ObjectMapper mapper = JSON.getMapper();
                String json = mapper.writeValueAsString(value);
                params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, json));
            }
        }
        return params;
    }

    private static List<NameValuePair> parseDelimitedParams(QueryParamsMetadata queryParamsMetadata, Object value, String delimiter) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        switch (Types.getType(value.getClass())) {
            case ARRAY: {
                Object[] array = (Object[])value;
                ArrayList<String> values = new ArrayList<String>();
                ArrayList<String> items = new ArrayList<String>();
                for (Object v2 : array) {
                    if (queryParamsMetadata.explode) {
                        values.add(Utils.valToString(v2));
                        continue;
                    }
                    items.add(Utils.valToString(v2));
                }
                if (items.size() > 0) {
                    values.add(String.join((CharSequence)delimiter, items));
                }
                params.addAll(values.stream().map(v -> new BasicNameValuePair(queryParamsMetadata.name, v)).collect(Collectors.toList()));
                break;
            }
            case MAP: {
                Map map = (Map)value;
                ArrayList<String> items = new ArrayList<String>();
                for (Map.Entry entry : map.entrySet()) {
                    String key = Utils.valToString(entry.getKey());
                    String val = Utils.valToString(entry.getValue());
                    if (queryParamsMetadata.explode) {
                        params.add((NameValuePair)new BasicNameValuePair(key, val));
                        continue;
                    }
                    items.add(String.format("%s%s%s", key, delimiter, val));
                }
                if (items.size() <= 0) break;
                params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, String.join((CharSequence)delimiter, items)));
                break;
            }
            case OBJECT: {
                Field[] fields = value.getClass().getFields();
                ArrayList<String> items = new ArrayList<String>();
                for (Field field : fields) {
                    QueryParamsMetadata metadata;
                    Object val = field.get(value);
                    if (val == null || (metadata = QueryParamsMetadata.parse(field)) == null) continue;
                    if (queryParamsMetadata.explode) {
                        params.add((NameValuePair)new BasicNameValuePair(metadata.name, Utils.valToString(val)));
                        continue;
                    }
                    items.add(String.format("%s%s%s", metadata.name, delimiter, Utils.valToString(val)));
                }
                if (items.size() <= 0) break;
                params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, String.join((CharSequence)delimiter, items)));
                break;
            }
            default: {
                params.add((NameValuePair)new BasicNameValuePair(queryParamsMetadata.name, Utils.valToString(value)));
            }
        }
        return params;
    }

    private static List<NameValuePair> parseDeepObjectParams(QueryParamsMetadata queryParamsMetadata, Object value) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        switch (Types.getType(value.getClass())) {
            case MAP: {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    String key = Utils.valToString(entry.getKey());
                    Object val = entry.getValue();
                    if (val.getClass().isArray()) {
                        for (Object v : (Object[])val) {
                            params.add((NameValuePair)new BasicNameValuePair(String.format("%s[%s]", queryParamsMetadata.name, key), Utils.valToString(v)));
                        }
                        continue;
                    }
                    params.add((NameValuePair)new BasicNameValuePair(String.format("%s[%s]", queryParamsMetadata.name, key), Utils.valToString(val)));
                }
                return params;
            }
            case OBJECT: {
                Field[] fields;
                for (Field field : fields = value.getClass().getFields()) {
                    QueryParamsMetadata metadata;
                    Object val = field.get(value);
                    if (val == null || (metadata = QueryParamsMetadata.parse(field)) == null) continue;
                    if (val.getClass().isArray()) {
                        for (Object v : (Object[])val) {
                            params.add((NameValuePair)new BasicNameValuePair(String.format("%s[%s]", queryParamsMetadata.name, metadata.name), Utils.valToString(v)));
                        }
                        continue;
                    }
                    params.add((NameValuePair)new BasicNameValuePair(String.format("%s[%s]", queryParamsMetadata.name, metadata.name), Utils.valToString(val)));
                }
                return params;
            }
        }
        throw new Exception("DeepObject style only supports Map and Object types");
    }
}

