/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api.utils;

import com.airbyte.api.utils.HTTPClient;
import com.airbyte.api.utils.SecurityMetadata;
import com.airbyte.api.utils.SpeakeasyHTTPSecurityClient;
import com.airbyte.api.utils.Types;
import com.airbyte.api.utils.Utils;
import java.lang.reflect.Field;
import java.util.Base64;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Security {
    public static SpeakeasyHTTPSecurityClient createClient(HTTPClient client, Object security) throws Exception {
        SpeakeasyHTTPSecurityClient securityClient = new SpeakeasyHTTPSecurityClient(client);
        if (security != null) {
            Field[] fields;
            for (Field field : fields = security.getClass().getFields()) {
                SecurityMetadata securityMetadata;
                Object value = field.get(security);
                if (value == null || (securityMetadata = SecurityMetadata.parse(field)) == null) continue;
                if (securityMetadata.option) {
                    Security.parseSecurityOption(securityClient, value);
                    return securityClient;
                }
                if (!securityMetadata.scheme) continue;
                if (securityMetadata.subtype != null && securityMetadata.subtype.equals("basic") && Types.getType(value.getClass()) != Types.OBJECT) {
                    Security.parseSecurityScheme(securityClient, securityMetadata, security);
                    return securityClient;
                }
                Security.parseSecurityScheme(securityClient, securityMetadata, value);
            }
        }
        return securityClient;
    }

    private static void parseSecurityOption(SpeakeasyHTTPSecurityClient client, Object option) throws Exception {
        Field[] fields;
        for (Field field : fields = option.getClass().getFields()) {
            SecurityMetadata securityMetadata;
            Object value = field.get(option);
            if (value == null || (securityMetadata = SecurityMetadata.parse(field)) == null || !securityMetadata.scheme) continue;
            Security.parseSecurityScheme(client, securityMetadata, value);
        }
    }

    private static void parseSecurityScheme(SpeakeasyHTTPSecurityClient client, SecurityMetadata schemeMetadata, Object scheme) throws Exception {
        if (Types.getType(scheme.getClass()) == Types.OBJECT) {
            Field[] fields;
            if (schemeMetadata.type.equals("http") && schemeMetadata.subtype.equals("basic")) {
                Security.parseBasicAuthScheme(client, scheme);
                return;
            }
            for (Field field : fields = scheme.getClass().getFields()) {
                SecurityMetadata securityMetadata;
                Object value = field.get(scheme);
                if (value == null || (securityMetadata = SecurityMetadata.parse(field)) == null || securityMetadata.name.isEmpty()) continue;
                Security.parseSecuritySchemeValue(client, schemeMetadata, securityMetadata, value);
            }
        } else {
            Security.parseSecuritySchemeValue(client, schemeMetadata, schemeMetadata, scheme);
        }
    }

    private static void parseSecuritySchemeValue(SpeakeasyHTTPSecurityClient client, SecurityMetadata schemeMetadata, SecurityMetadata securityMetadata, Object value) throws Exception {
        block6 : switch (schemeMetadata.type) {
            case "apiKey": {
                switch (schemeMetadata.subtype) {
                    case "header": {
                        client.addHeader(securityMetadata.name, Utils.valToString(value));
                        break block6;
                    }
                    case "query": {
                        client.addQueryParam((NameValuePair)new BasicNameValuePair(securityMetadata.name, Utils.valToString(value)));
                        break block6;
                    }
                    case "cookie": {
                        client.addHeader("Cookie", String.format("%s=%s", securityMetadata.name, Utils.valToString(value)));
                        break block6;
                    }
                }
                throw new Error("Unsupported security scheme subtype for apiKey: " + securityMetadata.subtype);
            }
            case "openIdConnect": {
                client.addHeader(securityMetadata.name, Utils.valToString(value));
                break;
            }
            case "oauth2": {
                client.addHeader(securityMetadata.name, Utils.valToString(value));
                break;
            }
            case "http": {
                switch (schemeMetadata.subtype) {
                    case "bearer": {
                        client.addHeader(securityMetadata.name, Utils.prefixBearer(Utils.valToString(value)));
                        break block6;
                    }
                }
                throw new Error("Unsupported security scheme subtype for bearer");
            }
            default: {
                throw new Error("Unsupported security scheme type");
            }
        }
    }

    private static void parseBasicAuthScheme(SpeakeasyHTTPSecurityClient client, Object scheme) throws IllegalAccessException {
        Field[] fields = scheme.getClass().getFields();
        String username = "";
        String password = "";
        block8: for (Field field : fields) {
            SecurityMetadata securityMetadata;
            Object value = field.get(scheme);
            if (value == null || (securityMetadata = SecurityMetadata.parse(field)) == null || securityMetadata.name.isEmpty()) continue;
            switch (securityMetadata.name) {
                case "username": {
                    username = Utils.valToString(value);
                    continue block8;
                }
                case "password": {
                    password = Utils.valToString(value);
                    continue block8;
                }
                default: {
                    throw new Error("Unsupported security scheme field for basic auth: " + securityMetadata.name);
                }
            }
        }
        client.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(String.format("%s:%s", username, password).getBytes()));
    }

    private Security() {
    }
}

