/*
 * Decompiled with CFR 0.152.
 */
package com.airbyte.api.utils;

import com.airbyte.api.utils.HTTPClient;
import com.airbyte.api.utils.HeaderMetadata;
import com.airbyte.api.utils.JSON;
import com.airbyte.api.utils.PathParamsMetadata;
import com.airbyte.api.utils.QueryParameters;
import com.airbyte.api.utils.RequestBody;
import com.airbyte.api.utils.Security;
import com.airbyte.api.utils.SerializedBody;
import com.airbyte.api.utils.Types;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;

public final class Utils {
    public static String generateURL(String baseURL, String path) throws IllegalArgumentException, IllegalAccessException {
        if (baseURL != null && baseURL.endsWith("/")) {
            baseURL = baseURL.split("/")[0];
        }
        return baseURL + path;
    }

    public static <T> String generateURL(Class<T> type, String baseURL, String path, T params, Map<String, Map<String, Map<String, Object>>> globals) throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        Field[] fields;
        if (baseURL != null && baseURL.endsWith("/")) {
            baseURL = baseURL.split("/")[0];
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        block11: for (Field field : fields = type.getFields()) {
            PathParamsMetadata pathParamsMetadata = PathParamsMetadata.parse(field);
            if (pathParamsMetadata == null) continue;
            Object value = params != null ? field.get(params) : null;
            if ((value = Utils.populateGlobal(value, field.getName(), "pathParam", globals)) == null) continue;
            if (pathParamsMetadata.serialization != null && !pathParamsMetadata.serialization.isBlank()) {
                Map<String, String> serialized = Utils.parseSerializedParams(pathParamsMetadata, value);
                pathParams.putAll(serialized);
                continue;
            }
            switch (pathParamsMetadata.style) {
                case "simple": {
                    switch (Types.getType(value.getClass())) {
                        case ARRAY: {
                            Object[] array = (Object[])value;
                            if (array.length == 0) continue block11;
                            pathParams.put(pathParamsMetadata.name, String.join((CharSequence)",", Arrays.asList(array).stream().map(v -> Utils.valToString(v)).collect(Collectors.toList())));
                            continue block11;
                        }
                        case MAP: {
                            Map map = (Map)value;
                            if (map.size() == 0) continue block11;
                            pathParams.put(pathParamsMetadata.name, String.join((CharSequence)",", map.entrySet().stream().map(e -> {
                                if (pathParamsMetadata.explode) {
                                    return String.format("%s=%s", Utils.valToString(e.getKey()), Utils.valToString(e.getValue()));
                                }
                                return String.format("%s,%s", Utils.valToString(e.getKey()), Utils.valToString(e.getValue()));
                            }).collect(Collectors.toList())));
                            continue block11;
                        }
                        case OBJECT: {
                            Field[] valueFields;
                            ArrayList<String> values = new ArrayList<String>();
                            for (Field valueField : valueFields = value.getClass().getFields()) {
                                Object val;
                                PathParamsMetadata valuePathParamsMetadata = PathParamsMetadata.parse(valueField);
                                if (valuePathParamsMetadata == null || (val = valueField.get(value)) == null) continue;
                                if (pathParamsMetadata.explode) {
                                    values.add(String.format("%s=%s", valuePathParamsMetadata.name, Utils.valToString(val)));
                                    continue;
                                }
                                values.add(String.format("%s,%s", valuePathParamsMetadata.name, Utils.valToString(val)));
                            }
                            pathParams.put(pathParamsMetadata.name, String.join((CharSequence)",", values));
                            continue block11;
                        }
                        default: {
                            pathParams.put(pathParamsMetadata.name, Utils.valToString(value));
                        }
                    }
                }
            }
        }
        return baseURL + Utils.templateUrl(path, pathParams);
    }

    public static boolean matchContentType(String contentType, String pattern) {
        if (contentType == null || contentType.isBlank()) {
            return false;
        }
        if (contentType.equals(pattern) || pattern.equals("*") || pattern.equals("*/*")) {
            return true;
        }
        String[] contentTypeParts = contentType.split(";");
        if (contentTypeParts.length == 0) {
            return false;
        }
        String mediaType = contentTypeParts[0];
        if (mediaType.equals(pattern)) {
            return true;
        }
        String[] mediaTypeParts = mediaType.split("/");
        return mediaTypeParts.length == 2 && (String.format("%s/*", mediaTypeParts[0]).equals(pattern) || String.format("*/%s", mediaTypeParts[1]).equals(pattern));
    }

    public static SerializedBody serializeRequestBody(Object request, String requestField, String serializationMethod) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, UnsupportedOperationException, IOException {
        return RequestBody.serialize(request, requestField, serializationMethod);
    }

    public static <T> List<NameValuePair> getQueryParams(Class<T> type, T params, Map<String, Map<String, Map<String, Object>>> globals) throws Exception {
        return QueryParameters.parseQueryParams(type, params, globals);
    }

    public static HTTPClient configureSecurityClient(HTTPClient client, Object security) throws Exception {
        return Security.createClient(client, security);
    }

    public static String templateUrl(String url, Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        Pattern p = Pattern.compile("(\\{.*?\\})");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String match = m.group(1);
            String key = match.substring(1, match.length() - 1);
            String value = params.get(key);
            if (value == null) continue;
            m.appendReplacement(sb, value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    /*
     * Could not resolve type clashes
     */
    public static Map<String, List<String>> getHeaders(Object headers) throws Exception {
        Field[] fields;
        if (headers == null) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        block5: for (Field field : fields = headers.getClass().getFields()) {
            Object value;
            HeaderMetadata headerMetadata = HeaderMetadata.parse(field);
            if (headerMetadata == null || (value = field.get(headers)) == null) continue;
            switch (Types.getType(value.getClass())) {
                case OBJECT: {
                    Field[] valueFields;
                    ArrayList<String> items = new ArrayList<String>();
                    for (Field valueField : valueFields = value.getClass().getFields()) {
                        Object valueFieldValue;
                        HeaderMetadata valueHeaderMetadata = HeaderMetadata.parse(valueField);
                        if (valueHeaderMetadata == null || valueHeaderMetadata.name == null || valueHeaderMetadata.name.isBlank() || (valueFieldValue = valueField.get(value)) == null) continue;
                        if (headerMetadata.explode) {
                            items.add(String.format("%s=%s", valueHeaderMetadata.name, Utils.valToString(valueFieldValue)));
                            continue;
                        }
                        items.add(valueHeaderMetadata.name);
                        items.add(Utils.valToString(valueFieldValue));
                    }
                    if (!result.containsKey(headerMetadata.name)) {
                        result.put(headerMetadata.name, new ArrayList());
                    }
                    Object values = (List)result.get(headerMetadata.name);
                    values.add(String.join((CharSequence)",", items));
                    continue block5;
                }
                case MAP: {
                    Map map = (Map)value;
                    if (map.size() == 0) continue block5;
                    ArrayList<String> items = new ArrayList<String>();
                    for (Map.Entry entry : map.entrySet()) {
                        if (headerMetadata.explode) {
                            items.add(String.format("%s=%s", Utils.valToString(entry.getKey()), Utils.valToString(entry.getValue())));
                            continue;
                        }
                        items.add(Utils.valToString(entry.getKey()));
                        items.add(Utils.valToString(entry.getValue()));
                    }
                    if (!result.containsKey(headerMetadata.name)) {
                        result.put(headerMetadata.name, new ArrayList());
                    }
                    Object values = (List)result.get(headerMetadata.name);
                    values.add(String.join((CharSequence)",", items));
                    continue block5;
                }
                case ARRAY: {
                    Object[] array = (Object[])value;
                    if (array.length == 0) continue block5;
                    ArrayList<String> items = new ArrayList();
                    for (Object item : array) {
                        items.add(Utils.valToString(item));
                    }
                    if (!result.containsKey(headerMetadata.name)) {
                        result.put(headerMetadata.name, new ArrayList());
                    }
                    Object values = (List)result.get(headerMetadata.name);
                    values.add(String.join((CharSequence)",", items));
                    continue block5;
                }
                default: {
                    if (!result.containsKey(headerMetadata.name)) {
                        result.put(headerMetadata.name, new ArrayList());
                    }
                    List values = (List)result.get(headerMetadata.name);
                    values.add(Utils.valToString(value));
                    continue block5;
                }
            }
        }
        return result;
    }

    public static String valToString(Object value) {
        switch (Types.getType(value.getClass())) {
            case ENUM: {
                try {
                    return String.valueOf(value.getClass().getDeclaredField("value").get(value));
                }
                catch (Exception e) {
                    return "ERROR_UNKNOWN_VALUE";
                }
            }
        }
        return String.valueOf(value);
    }

    public static String prefixBearer(String authHeaderValue) {
        if (authHeaderValue.toLowerCase().startsWith("bearer ")) {
            return authHeaderValue;
        }
        return "Bearer " + authHeaderValue;
    }

    public static Object populateGlobal(Object value, String fieldName, String paramType, Map<String, Map<String, Map<String, Object>>> globals) {
        Object globalVal;
        if (value == null && globals != null && globals.containsKey("parameters") && globals.get("parameters").containsKey(paramType) && (globalVal = globals.get("parameters").get(paramType).get(fieldName)) != null) {
            value = globalVal;
        }
        return value;
    }

    private static Map<String, String> parseSerializedParams(PathParamsMetadata pathParamsMetadata, Object value) throws JsonProcessingException {
        HashMap<String, String> params = new HashMap<String, String>();
        switch (pathParamsMetadata.serialization) {
            case "json": {
                ObjectMapper mapper = JSON.getMapper();
                String json = mapper.writeValueAsString(value);
                params.put(pathParamsMetadata.name, URLEncoder.encode(json, StandardCharsets.UTF_8));
            }
        }
        return params;
    }

    private Utils() {
    }
}

