/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.porcupine.interceptors;

import com.airhacks.porcupine.execution.entity.Statistics;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
public class HttpHeaderStatisticInjector
implements WriterInterceptor {
    @Inject
    Instance<List<Statistics>> statistics;

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        List pipelines = (List)this.statistics.get();
        MultivaluedMap headers = context.getHeaders();
        pipelines.forEach(s -> headers.add((Object)("x-porcupine-statistics-" + s.getPipelineName()), (Object)this.serializeStatistics((Statistics)s)));
        context.proceed();
    }

    public String serializeStatistics(Statistics statistics) {
        JsonObjectBuilder stats = Json.createObjectBuilder();
        stats.add("pipelineName", statistics.getPipelineName());
        String handlerName = statistics.getRejectedExecutionHandlerName();
        if (handlerName != null) {
            stats.add("rejectedExecutionHandlerName", handlerName);
        }
        stats.add("activeThreadCount", statistics.getActiveThreadCount());
        stats.add("completedTaskCount", statistics.getCompletedTaskCount());
        stats.add("corePoolSize", statistics.getCorePoolSize());
        stats.add("currentThreadPoolSize", statistics.getCurrentThreadPoolSize());
        stats.add("largestThreadPoolSize", statistics.getLargestThreadPoolSize());
        stats.add("maximumPoolSize", statistics.getMaximumPoolSize());
        stats.add("rejectedTasks", statistics.getRejectedTasks());
        stats.add("remainingQueueCapacity", statistics.getRemainingQueueCapacity());
        stats.add("minQueueCapacity", statistics.getMinQueueCapacity());
        stats.add("totalNumberOfTasks", statistics.getTotalNumberOfTasks());
        StringWriter writer = new StringWriter();
        try (JsonWriter outputWriter = Json.createWriter((Writer)writer);){
            outputWriter.writeObject(stats.build());
        }
        return writer.toString();
    }
}

