/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.common.toolkit;

import com.aizuda.common.toolkit.StringUtils;
import com.aizuda.common.toolkit.ThrowableUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class JacksonUtils {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtils.class);

    public static String toJSONString(Object object) {
        try {
            return JacksonUtils.toJsonThrows(object);
        }
        catch (Exception e) {
            log.error("toJSONString error.", (Throwable)e);
            return null;
        }
    }

    public static <T> T parse(String json, Class<T> tClass) {
        try {
            return JacksonUtils.parseThrows(json, tClass);
        }
        catch (Exception e) {
            log.error("JSONString parse error.", (Throwable)e);
            return null;
        }
    }

    public static <T> T parse(String json, TypeReference<T> valueTypeRef) {
        try {
            return JacksonUtils.parseThrows(json, valueTypeRef);
        }
        catch (Exception e) {
            log.error("JSONString parse error.", (Throwable)e);
            return null;
        }
    }

    public static String toJsonThrows(Object object) throws Exception {
        return JacksonUtils.getObjectMapper().writeValueAsString(object);
    }

    public static <T> T parseThrows(String json, Class<T> tClass) throws Exception {
        return (T)JacksonUtils.getObjectMapper().readValue(json, tClass);
    }

    public static <T> T parseThrows(String json, TypeReference<T> valueTypeRef) throws JsonProcessingException {
        return (T)JacksonUtils.getObjectMapper().readValue(json, valueTypeRef);
    }

    @Nullable
    public static String toJson(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        try {
            return JacksonUtils.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static byte[] toJsonAsBytes(@Nullable Object object) {
        if (object == null) {
            return new byte[0];
        }
        try {
            return JacksonUtils.getObjectMapper().writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static JsonNode readTree(String jsonString) {
        Objects.requireNonNull(jsonString, "jsonString is null");
        try {
            return JacksonUtils.getObjectMapper().readTree(jsonString);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static JsonNode readTree(InputStream in) {
        Objects.requireNonNull(in, "InputStream in is null");
        try {
            return JacksonUtils.getObjectMapper().readTree(in);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static JsonNode readTree(byte[] content) {
        Objects.requireNonNull(content, "byte[] content is null");
        try {
            return JacksonUtils.getObjectMapper().readTree(content);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static JsonNode readTree(JsonParser jsonParser) {
        Objects.requireNonNull(jsonParser, "jsonParser is null");
        try {
            return (JsonNode)JacksonUtils.getObjectMapper().readTree(jsonParser);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, Class<T> valueType) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(content, valueType);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, Class<T> valueType) {
        if (!StringUtils.hasLength(jsonString)) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(jsonString, valueType);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, Class<T> valueType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(in, valueType);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, TypeReference<T> typeReference) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(content, typeReference);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, TypeReference<T> typeReference) {
        if (!StringUtils.hasLength(jsonString)) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, TypeReference<T> typeReference) {
        if (in == null) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(in, typeReference);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, JavaType javaType) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(content, javaType);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, JavaType javaType) {
        if (!StringUtils.hasLength(jsonString)) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(jsonString, javaType);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, JavaType javaType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)JacksonUtils.getObjectMapper().readValue(in, javaType);
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static MapType getMapType(Class<?> valueClass) {
        return JacksonUtils.getMapType(String.class, valueClass);
    }

    public static MapType getMapType(Class<?> keyClass, Class<?> valueClass) {
        return JacksonUtils.getObjectMapper().getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
    }

    public static CollectionLikeType getListType(Class<?> elementClass) {
        return JacksonUtils.getObjectMapper().getTypeFactory().constructCollectionLikeType(List.class, elementClass);
    }

    public static JavaType getParametricType(Class<?> parametrized, Class<?> ... parameterClasses) {
        return JacksonUtils.getObjectMapper().getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
    }

    public static <T> List<T> readList(@Nullable byte[] content, Class<T> elementClass) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return Collections.emptyList();
        }
        try {
            return (List)JacksonUtils.getObjectMapper().readValue(content, (JavaType)JacksonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable InputStream content, Class<T> elementClass) {
        if (content == null) {
            return Collections.emptyList();
        }
        try {
            return (List)JacksonUtils.getObjectMapper().readValue(content, (JavaType)JacksonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable String content, Class<T> elementClass) {
        if (!StringUtils.hasLength(content)) {
            return Collections.emptyList();
        }
        try {
            return (List)JacksonUtils.getObjectMapper().readValue(content, (JavaType)JacksonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static Map<String, Object> readMap(@Nullable byte[] content) {
        return JacksonUtils.readMap(content, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable InputStream content) {
        return JacksonUtils.readMap(content, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable String content) {
        return JacksonUtils.readMap(content, Object.class);
    }

    public static <V> Map<String, V> readMap(@Nullable byte[] content, Class<?> valueClass) {
        return JacksonUtils.readMap(content, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable InputStream content, Class<?> valueClass) {
        return JacksonUtils.readMap(content, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable String content, Class<?> valueClass) {
        return JacksonUtils.readMap(content, String.class, valueClass);
    }

    public static <K, V> Map<K, V> readMap(@Nullable byte[] content, Class<?> keyClass, Class<?> valueClass) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JacksonUtils.getObjectMapper().readValue(content, (JavaType)JacksonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable InputStream content, Class<?> keyClass, Class<?> valueClass) {
        if (content == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JacksonUtils.getObjectMapper().readValue(content, (JavaType)JacksonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable String content, Class<?> keyClass, Class<?> valueClass) {
        if (!StringUtils.hasLength(content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JacksonUtils.getObjectMapper().readValue(content, (JavaType)JacksonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)JacksonUtils.getObjectMapper().convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, JavaType toValueType) {
        return (T)JacksonUtils.getObjectMapper().convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)JacksonUtils.getObjectMapper().convertValue(fromValue, toValueTypeRef);
    }

    public static <T> T treeToValue(TreeNode treeNode, Class<T> valueType) {
        try {
            return (T)JacksonUtils.getObjectMapper().treeToValue(treeNode, valueType);
        }
        catch (JsonProcessingException e) {
            throw ThrowableUtils.unchecked(e);
        }
    }

    public static <T extends JsonNode> T valueToTree(@Nullable Object fromValue) {
        return (T)JacksonUtils.getObjectMapper().valueToTree(fromValue);
    }

    public static ObjectNode createObjectNode() {
        return JacksonUtils.getObjectMapper().createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return JacksonUtils.getObjectMapper().createArrayNode();
    }

    public static ObjectMapper getObjectMapper() {
        return JacksonHolder.INSTANCE;
    }

    private static class JacksonObjectMapper
    extends ObjectMapper {
        private static final long serialVersionUID = 4288193147502386170L;

        JacksonObjectMapper() {
            super(JacksonObjectMapper.jsonFactory());
            super.setLocale(Locale.CHINA);
            super.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            super.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
            super.registerModule((Module)simpleModule);
            super.registerModule((Module)new JavaTimeModule());
            super.findAndRegisterModules();
        }

        JacksonObjectMapper(ObjectMapper src) {
            super(src);
        }

        private static JsonFactory jsonFactory() {
            return JsonFactory.builder().configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true).configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, true).build();
        }

        public ObjectMapper copy() {
            return new JacksonObjectMapper(this);
        }
    }

    private static class JacksonHolder {
        private static final ObjectMapper INSTANCE = new JacksonObjectMapper();

        private JacksonHolder() {
        }
    }
}

