/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.common.toolkit;

import com.baomidou.kisso.common.util.Base64Util;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class RsaUtils {
    public static final String PKCS1 = "RSA/ECB/PKCS1Padding";
    public static final String RSA = "RSA";
    private String keyFormat;
    private int keyLength;

    private RsaUtils(String keyFormat, int keyLength) {
        this.keyFormat = keyFormat;
        this.keyLength = keyLength;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static RsaUtils newInstance(String keyFormat, int keyLength) {
        return new RsaUtils(keyFormat, keyLength);
    }

    public static RsaUtils get1024PKCS1() {
        return RsaUtils.newInstance(PKCS1, 1024);
    }

    public static RsaUtils get2048PKCS1() {
        return RsaUtils.newInstance(PKCS1, 2048);
    }

    public static RsaUtils get1024PKCS8() {
        return RsaUtils.newInstance(RSA, 1024);
    }

    public static RsaUtils get2048PKCS8() {
        return RsaUtils.newInstance(RSA, 2048);
    }

    public KeyStore createKeys() throws Exception {
        KeyPairGenerator keyPairGeno = KeyPairGenerator.getInstance(RSA);
        keyPairGeno.initialize(this.keyLength);
        KeyPair keyPair = keyPairGeno.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        KeyStore keyStore = new KeyStore();
        if (Objects.equals(PKCS1, this.keyFormat)) {
            keyStore.setPublicKey(Base64Util.encryptBASE64((byte[])publicKey.getEncoded()));
            keyStore.setPrivateKey(RsaUtils.convertPkcs8ToPkcs1(privateKey.getEncoded()));
        } else {
            keyStore.setPublicKey(Base64Util.encryptBASE64((byte[])publicKey.getEncoded()));
            keyStore.setPrivateKey(Base64Util.encryptBASE64((byte[])privateKey.getEncoded()));
        }
        return keyStore;
    }

    public RSAPublicKey getPublicKey(byte[] pubKeyData) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubKeyData);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return (RSAPublicKey)keyFactory.generatePublic(keySpec);
    }

    public RSAPublicKey getPublicKey(String pubKey) throws Exception {
        return this.getPublicKey(Base64Util.decryptBASE64((String)pubKey));
    }

    public RSAPrivateKey getPrivateKey(String priKey) throws Exception {
        return this.getPrivateKey(Base64Util.decryptBASE64((String)priKey));
    }

    public RSAPrivateKey getPrivateKey(byte[] keyBytes) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
    }

    public Cipher getCipher(String transformation, int mode, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(mode, key);
        return cipher;
    }

    public String encryptByPublicKey(String data, RSAPublicKey publicKey) throws Exception {
        Cipher cipher = this.getCipher(this.keyFormat, 1, publicKey);
        int key_len = publicKey.getModulus().bitLength() / 8;
        String[] dataArr = this.splitString(data, key_len - 11);
        String text = "";
        for (String s : dataArr) {
            text = text + this.bcd2Str(cipher.doFinal(s.getBytes()));
        }
        return text;
    }

    public String encryptByPrivateKey(String data, String privateKey) throws Exception {
        return this.encryptByPrivateKey(data, this.getPrivateKey(privateKey));
    }

    public String encryptByPrivateKey(String data, RSAPrivateKey privateKey) throws Exception {
        Cipher cipher = this.getCipher(this.keyFormat, 1, privateKey);
        int key_len = privateKey.getModulus().bitLength() / 8;
        String[] dataArr = this.splitString(data, key_len - 11);
        String text = "";
        for (String s : dataArr) {
            text = text + this.bcd2Str(cipher.doFinal(s.getBytes()));
        }
        return text;
    }

    public String decryptByPrivateKey(String data, String privateKey) throws Exception {
        return this.decryptByPrivateKey(data, this.getPrivateKey(privateKey));
    }

    public String decryptByPrivateKey(String data, RSAPrivateKey privateKey) throws Exception {
        byte[][] arrays;
        Cipher cipher = this.getCipher(this.keyFormat, 2, privateKey);
        int key_len = privateKey.getModulus().bitLength() / 8;
        byte[] bytes = data.getBytes();
        byte[] bcd = RsaUtils.ASCII_To_BCD(bytes, bytes.length);
        String text = "";
        for (byte[] arr : arrays = this.splitArray(bcd, key_len)) {
            text = text + new String(cipher.doFinal(arr));
        }
        return text;
    }

    public String decryptByPublicKey(String data, RSAPublicKey rsaPublicKey) throws Exception {
        byte[][] arrays;
        Cipher cipher = this.getCipher(this.keyFormat, 2, rsaPublicKey);
        int key_len = rsaPublicKey.getModulus().bitLength() / 8;
        byte[] bytes = data.getBytes();
        byte[] bcd = RsaUtils.ASCII_To_BCD(bytes, bytes.length);
        String text = "";
        for (byte[] arr : arrays = this.splitArray(bcd, key_len)) {
            text = text + new String(cipher.doFinal(arr));
        }
        return text;
    }

    public static String convertPkcs8ToPkcs1(byte[] privateKeyData) throws Exception {
        PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)privateKeyData);
        ASN1Encodable asn1Encodable = pkInfo.parsePrivateKey();
        ASN1Primitive primitive = asn1Encodable.toASN1Primitive();
        byte[] privateKeyPKCS1 = primitive.getEncoded();
        return Base64Util.encryptBASE64((byte[])privateKeyPKCS1);
    }

    public static byte[] ASCII_To_BCD(byte[] ascii, int asc_len) {
        byte[] bcd = new byte[asc_len / 2];
        int j = 0;
        for (int i = 0; i < (asc_len + 1) / 2; ++i) {
            bcd[i] = RsaUtils.asc_to_bcd(ascii[j++]);
            bcd[i] = (byte)((j >= asc_len ? 0 : RsaUtils.asc_to_bcd(ascii[j++]) & 0xFF) + (bcd[i] << 4));
        }
        return bcd;
    }

    public static byte asc_to_bcd(byte asc) {
        byte bcd = asc >= 48 && asc <= 57 ? (byte)(asc - 48) : (asc >= 65 && asc <= 70 ? (byte)(asc - 65 + 10) : (asc >= 97 && asc <= 102 ? (byte)(asc - 97 + 10) : (byte)(asc - 48)));
        return bcd;
    }

    public String bcd2Str(byte[] bytes) {
        char[] temp = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            char val = (char)((bytes[i] & 0xF0) >> 4 & 0xF);
            temp[i * 2] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            val = (char)(bytes[i] & 0xF);
            temp[i * 2 + 1] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
        }
        return new String(temp);
    }

    public String[] splitString(String string, int len) {
        int x = string.length() / len;
        int y = string.length() % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        String[] strings = new String[x + z];
        String str = "";
        for (int i = 0; i < x + z; ++i) {
            str = i == x + z - 1 && y != 0 ? string.substring(i * len, i * len + y) : string.substring(i * len, i * len + len);
            strings[i] = str;
        }
        return strings;
    }

    public byte[][] splitArray(byte[] data, int len) {
        int x = data.length / len;
        int y = data.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(data, i * len, arr, 0, y);
            } else {
                System.arraycopy(data, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static class KeyStore {
        private String publicKey;
        private String privateKey;

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }
    }
}

