/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.common.toolkit;

import com.aizuda.common.toolkit.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class StreamUtils {
    public static <O, R> List<R> map(List<O> list, Function<O, R> function) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(function).collect(Collectors.toList());
    }

    public static <E> List<E> peek(List<E> list, Consumer<E> function) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().peek(function).collect(Collectors.toList());
    }

    public static <E> List<E> filter(List<E> list, Predicate<E> predicate) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <E, K> Map<K, E> toMap(List<E> list, Function<E, K> keyFunction) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(HashMap::new, (m, v) -> m.put(Optional.ofNullable(v).map(keyFunction).orElse(null), v), HashMap::putAll);
    }

    public static <E, K> Map<K, List<E>> group(List<E> list, Function<E, K> keyFunction) {
        return StreamUtils.groupThen(list, keyFunction, Collectors.toList());
    }

    public static <E, K, R> Map<K, R> groupThen(List<E> list, Function<E, K> keyFunction, Collector<E, ?, R> downstream) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.groupingBy(keyFunction, downstream));
    }
}

