/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.common.toolkit;

import java.util.Arrays;
import org.springframework.lang.Nullable;

public class StringUtils {
    public static boolean hasLength(@Nullable String str) {
        return null != str && !str.isEmpty();
    }

    public static boolean allHasLength(String ... str) {
        return str != null && str.length != 0 && Arrays.stream(str).allMatch(StringUtils::hasLength);
    }

    public static boolean anyHasLength(String ... str) {
        return str != null && str.length != 0 && Arrays.stream(str).anyMatch(StringUtils::hasLength);
    }

    public static String substringByBytes(String str, int bytes) {
        if (StringUtils.hasLength(str)) {
            int len = 0;
            int strLength = str.length();
            for (int i = 0; i < strLength; ++i) {
                if ((len += str.charAt(i) > '\u00ff' ? 3 : 1) <= bytes) continue;
                return str.substring(0, i);
            }
        }
        return str;
    }
}

