/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.common.toolkit;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public class ThrowableUtils {
    public static RuntimeException unchecked(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return (RuntimeException)ThrowableUtils.runtime(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return (RuntimeException)ThrowableUtils.runtime(e);
    }

    private static <T extends Throwable> T runtime(Throwable throwable) throws T {
        throw throwable;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

