/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.init;

import com.aizuda.easy.retry.client.common.Lifecycle;
import com.aizuda.easy.retry.client.common.event.EasyRetryClosedEvent;
import com.aizuda.easy.retry.client.common.event.EasyRetryClosingEvent;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.util.EasyRetryVersion;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;

@Component
public class EasyRetryCloseListener
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(EasyRetryCloseListener.class);
    private final List<Lifecycle> lifecycleList;

    public void onApplicationEvent(ContextClosedEvent event) {
        log.info("Easy-Retry client about to shutdown v{}", (Object)EasyRetryVersion.getVersion());
        SpringContext.getContext().publishEvent((ApplicationEvent)new EasyRetryClosingEvent());
        this.lifecycleList.forEach(Lifecycle::close);
        SpringContext.getContext().publishEvent((ApplicationEvent)new EasyRetryClosedEvent());
        log.info("Easy-Retry client closed successfully v{}", (Object)EasyRetryVersion.getVersion());
    }

    public EasyRetryCloseListener(List<Lifecycle> lifecycleList) {
        this.lifecycleList = lifecycleList;
    }
}

