/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.init;

import com.aizuda.easy.retry.client.common.Lifecycle;
import com.aizuda.easy.retry.client.common.event.EasyRetryStartedEvent;
import com.aizuda.easy.retry.client.common.event.EasyRetryStartingEvent;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.util.EasyRetryVersion;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import java.util.List;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
public class EasyRetryStartListener
implements ApplicationRunner {
    private final List<Lifecycle> lifecycleList;
    private volatile boolean isStarted = false;

    public void run(ApplicationArguments args) throws Exception {
        if (this.isStarted) {
            EasyRetryLog.LOCAL.info("Easy-Retry client already started v{}", new Object[]{EasyRetryVersion.getVersion()});
            return;
        }
        System.out.println(MessageFormatter.format((String)"  ___                ___     _            \n | __|__ _ ____  _  | _ \\___| |_ _ _ _  _ \n | _|/ _` (_-< || | |   / -_)  _| '_| || |\n |___\\__,_/__/\\_, | |_|_\\___|\\__|_|  \\_, |\n              |__/                   |__/ \n :: Easy Retry ::                     (v{})       \n", (Object)EasyRetryVersion.getVersion()).getMessage());
        EasyRetryLog.LOCAL.info("Easy-Retry client is preparing to start... v{}", new Object[]{EasyRetryVersion.getVersion()});
        SpringContext.getContext().publishEvent((ApplicationEvent)new EasyRetryStartingEvent());
        this.lifecycleList.forEach(Lifecycle::start);
        SpringContext.getContext().publishEvent((ApplicationEvent)new EasyRetryStartedEvent());
        this.isStarted = true;
        EasyRetryLog.LOCAL.info("Easy-Retry client started successfully v{}", new Object[]{EasyRetryVersion.getVersion()});
    }

    public EasyRetryStartListener(List<Lifecycle> lifecycleList) {
        this.lifecycleList = lifecycleList;
    }
}

