/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.netty;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.client.common.cache.GroupVersionCache;
import com.aizuda.easy.retry.client.common.config.EasyRetryProperties;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.HeadersEnum;
import com.aizuda.easy.retry.common.core.util.NetUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;

public class NettyChannel {
    private static final Logger log = LoggerFactory.getLogger(NettyChannel.class);
    private static Channel CHANNEL;
    private static final String EASY_RETRY_SERVER_PORT = "easy-retry.server.port";
    private static final String EASY_RETRY_SERVER_HOST = "easy-retry.server.host";
    private static final String EASY_RETRY_CLIENT_PORT = "easy-retry.port";
    private static final String EASY_RETRY_CLIENT_HOST = "easy-retry.host";
    private static final String HOST_ID;
    private static final int PORT;
    private static final String HOST;

    private NettyChannel() {
    }

    public static int getServerPort() {
        EasyRetryProperties easyRetryProperties = (EasyRetryProperties)SpringContext.getContext().getBean(EasyRetryProperties.class);
        EasyRetryProperties.ServerConfig serverConfig = easyRetryProperties.getServer();
        String port = System.getProperty(EASY_RETRY_SERVER_PORT);
        if (StrUtil.isBlank((CharSequence)port)) {
            System.setProperty(EASY_RETRY_SERVER_PORT, String.valueOf(serverConfig.getPort()));
        }
        return Integer.parseInt(System.getProperty(EASY_RETRY_SERVER_PORT));
    }

    public static String getServerHost() {
        EasyRetryProperties easyRetryProperties = (EasyRetryProperties)SpringContext.getBean(EasyRetryProperties.class);
        EasyRetryProperties.ServerConfig serverConfig = easyRetryProperties.getServer();
        String host = System.getProperty(EASY_RETRY_SERVER_HOST);
        if (StrUtil.isBlank((CharSequence)host)) {
            System.setProperty(EASY_RETRY_SERVER_HOST, serverConfig.getHost());
        }
        return System.getProperty(EASY_RETRY_SERVER_HOST);
    }

    public static String getClientHost() {
        EasyRetryProperties easyRetryProperties = (EasyRetryProperties)SpringContext.getBean(EasyRetryProperties.class);
        String host = easyRetryProperties.getHost();
        if (StrUtil.isBlank((CharSequence)host)) {
            host = HOST;
        }
        return host;
    }

    public static Integer getClientPort() {
        EasyRetryProperties easyRetryProperties = (EasyRetryProperties)SpringContext.getBean(EasyRetryProperties.class);
        ServerProperties serverProperties = (ServerProperties)SpringContext.getBean(ServerProperties.class);
        Integer port = easyRetryProperties.getPort();
        if (Objects.isNull(port)) {
            port = Optional.ofNullable(serverProperties.getPort()).orElse(PORT);
        }
        return port;
    }

    public static void setChannel(Channel channel) {
        CHANNEL = channel;
    }

    public static void send(HttpMethod method, String url, String body) throws InterruptedException {
        if (Objects.isNull(CHANNEL)) {
            EasyRetryLog.LOCAL.error("send message but channel is null url:[{}] method:[{}] body:[{}] ", new Object[]{url, method, body});
            return;
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, url, Unpooled.wrappedBuffer((byte[])body.getBytes(StandardCharsets.UTF_8)));
        ServerProperties serverProperties = (ServerProperties)SpringContext.getBean(ServerProperties.class);
        EasyRetryProperties easyRetryProperties = (EasyRetryProperties)SpringContext.getBean(EasyRetryProperties.class);
        EasyRetryProperties.ServerConfig serverConfig = easyRetryProperties.getServer();
        if (Objects.isNull(serverConfig)) {
            EasyRetryLog.LOCAL.error("easy retry server config is null", new Object[0]);
            return;
        }
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)request.content().readableBytes()).set(HeadersEnum.HOST_ID.getKey(), (Object)HOST_ID).set(HeadersEnum.HOST_IP.getKey(), (Object)NettyChannel.getClientHost()).set(HeadersEnum.GROUP_NAME.getKey(), (Object)EasyRetryProperties.getGroup()).set(HeadersEnum.CONTEXT_PATH.getKey(), (Object)Optional.ofNullable(serverProperties.getServlet().getContextPath()).orElse("/")).set(HeadersEnum.HOST_PORT.getKey(), (Object)NettyChannel.getClientPort()).set(HeadersEnum.VERSION.getKey(), (Object)GroupVersionCache.getVersion()).set(HeadersEnum.HOST.getKey(), (Object)serverConfig.getHost()).set(HeadersEnum.NAMESPACE.getKey(), (Object)Optional.ofNullable(easyRetryProperties.getNamespace()).orElse("764d604ec6fc45f68cd92514c40e9e1a")).set(HeadersEnum.TOKEN.getKey(), (Object)Optional.ofNullable(easyRetryProperties.getToken()).orElse("ER_cKqBTPzCsWA3VyuCfFoccmuIEGXjr5KT"));
        CHANNEL.writeAndFlush((Object)request).sync();
    }

    static {
        HOST_ID = IdUtil.getSnowflake().nextIdStr();
        PORT = Integer.parseInt(System.getProperty(EASY_RETRY_CLIENT_PORT, String.valueOf(8080)));
        HOST = System.getProperty(EASY_RETRY_CLIENT_HOST, NetUtil.getLocalIpStr());
    }
}

