/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.netty;

import com.aizuda.easy.retry.client.common.NettyClient;
import com.aizuda.easy.retry.client.common.event.ChannelReconnectEvent;
import com.aizuda.easy.retry.client.common.netty.NettyHttpConnectClient;
import com.aizuda.easy.retry.client.common.netty.RpcContext;
import com.aizuda.easy.retry.client.common.proxy.RequestBuilder;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.model.NettyResult;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class NettyHttpClientHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(NettyHttpClientHandler.class);
    private NettyClient client = RequestBuilder.newBuilder().client(NettyClient.class).callback(nettyResult -> EasyRetryLog.LOCAL.info("heartbeat check requestId:[{}]", new Object[]{nettyResult.getRequestId()})).build();
    private NettyHttpConnectClient nettyHttpConnectClient;

    public NettyHttpClientHandler(NettyHttpConnectClient nettyHttpConnectClient) {
        this.nettyHttpConnectClient = nettyHttpConnectClient;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        FullHttpResponse response = msg;
        String content = response.content().toString(CharsetUtil.UTF_8);
        HttpHeaders headers = response.headers();
        EasyRetryLog.LOCAL.info("Receive server data content:[{}], headers:[{}]", new Object[]{content, headers});
        NettyResult nettyResult = (NettyResult)JsonUtil.parseObject((String)content, NettyResult.class);
        RpcContext.invoke(nettyResult.getRequestId(), nettyResult);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        EasyRetryLog.LOCAL.debug("channelRegistered", new Object[0]);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        EasyRetryLog.LOCAL.debug("channelUnregistered", new Object[0]);
        ctx.channel().eventLoop().schedule(() -> {
            try {
                SpringContext.getContext().publishEvent((ApplicationEvent)new ChannelReconnectEvent());
                this.nettyHttpConnectClient.reconnect();
            }
            catch (Exception e) {
                EasyRetryLog.LOCAL.error("reconnect error ", new Object[]{e});
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        EasyRetryLog.LOCAL.debug("channelActive", new Object[0]);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        EasyRetryLog.LOCAL.debug("channelInactive", new Object[0]);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        EasyRetryLog.LOCAL.debug("channelReadComplete", new Object[0]);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        EasyRetryLog.LOCAL.debug("channelWritabilityChanged", new Object[0]);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        EasyRetryLog.LOCAL.error("easy-retry netty-http client exception", new Object[]{cause});
        super.exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        EasyRetryLog.LOCAL.debug("userEventTriggered", new Object[0]);
        if (evt instanceof IdleStateEvent) {
            this.client.beat("PING");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

