/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.log.dialect;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.log.dialect.Log;
import com.aizuda.easy.retry.common.log.level.Level;
import java.io.Serializable;

public abstract class AbstractLog
implements Log,
Serializable {
    private static final long serialVersionUID = -3211115409504005616L;
    private static final String FQCN = AbstractLog.class.getName();

    @Override
    public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
    }

    @Override
    public void trace(Throwable t, Boolean remote) {
        this.trace(t, ExceptionUtil.getSimpleMessage((Throwable)t), remote, new Object[0]);
    }

    @Override
    public void trace(String format, Boolean remote, Object ... arguments) {
        this.trace(null, format, remote, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Boolean remote, Object ... arguments) {
        this.trace(FQCN, t, format, remote, arguments);
    }

    @Override
    public void debug(Throwable t, Boolean remote) {
        this.debug(t, ExceptionUtil.getSimpleMessage((Throwable)t), remote, new Object[0]);
    }

    @Override
    public void debug(String format, Boolean remote, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.debug((Throwable)arguments[0], format, remote, new Object[0]);
        } else {
            this.debug(null, format, remote, arguments);
        }
    }

    @Override
    public void debug(Throwable t, String format, Boolean remote, Object ... arguments) {
        this.debug(FQCN, t, format, remote, arguments);
    }

    @Override
    public void info(Throwable t, Boolean remote) {
        this.info(t, ExceptionUtil.getSimpleMessage((Throwable)t), remote, new Object[0]);
    }

    @Override
    public void info(String format, Boolean remote, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.info((Throwable)arguments[0], format, remote, new Object[0]);
        } else {
            this.info(null, format, remote, arguments);
        }
    }

    @Override
    public void info(Throwable t, String format, Boolean remote, Object ... arguments) {
        this.info(FQCN, t, format, remote, arguments);
    }

    @Override
    public void warn(Throwable t, Boolean remote) {
        this.warn(t, ExceptionUtil.getSimpleMessage((Throwable)t), remote, new Object[0]);
    }

    @Override
    public void warn(String format, Boolean remote, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.warn((Throwable)arguments[0], format, remote, new Object[0]);
        } else {
            this.warn(null, format, remote, arguments);
        }
    }

    @Override
    public void warn(Throwable t, String format, Boolean remote, Object ... arguments) {
        this.warn(FQCN, t, format, remote, arguments);
    }

    @Override
    public void error(Throwable t, Boolean remote) {
        this.error(t, ExceptionUtil.getSimpleMessage((Throwable)t), remote, new Object[0]);
    }

    @Override
    public void error(String format, Boolean remote, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.error((Throwable)arguments[0], format, remote, new Object[0]);
        } else {
            this.error(null, format, remote, arguments);
        }
    }

    @Override
    public void error(Throwable t, String format, Boolean remote, Object ... arguments) {
        this.error(FQCN, t, format, remote, arguments);
    }

    @Override
    public void log(Level level, String format, Boolean remote, Object ... arguments) {
        if (null != arguments && 1 == arguments.length && arguments[0] instanceof Throwable) {
            this.log(level, (Throwable)arguments[0], format, remote, new Object[0]);
        } else {
            this.log(level, null, format, remote, arguments);
        }
    }

    @Override
    public void log(Level level, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.log(FQCN, level, t, format, remote, arguments);
    }
}

