/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.log.dialect.log4j;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.log.dialect.AbstractLog;
import com.aizuda.easy.retry.common.log.factory.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;

public class Log4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final Logger logger;

    public Log4jLog(Logger logger) {
        this.logger = logger;
    }

    public Log4jLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public Log4jLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.log(fqcn, com.aizuda.easy.retry.common.log.level.Level.TRACE, t, format, remote, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.log(fqcn, com.aizuda.easy.retry.common.log.level.Level.DEBUG, t, format, remote, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.log(fqcn, com.aizuda.easy.retry.common.log.level.Level.INFO, t, format, remote, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.log(fqcn, com.aizuda.easy.retry.common.log.level.Level.WARN, t, format, remote, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.log(fqcn, com.aizuda.easy.retry.common.log.level.Level.ERROR, t, format, remote, arguments);
    }

    @Override
    public void log(String fqcn, com.aizuda.easy.retry.common.log.level.Level level, Throwable t, String format, Boolean remote, Object ... arguments) {
        Level log4jLevel = switch (level) {
            case com.aizuda.easy.retry.common.log.level.Level.TRACE -> Level.TRACE;
            case com.aizuda.easy.retry.common.log.level.Level.DEBUG -> Level.DEBUG;
            case com.aizuda.easy.retry.common.log.level.Level.INFO -> Level.INFO;
            case com.aizuda.easy.retry.common.log.level.Level.WARN -> Level.WARN;
            case com.aizuda.easy.retry.common.log.level.Level.ERROR -> Level.ERROR;
            default -> throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
        };
        if (this.logger.isEnabledFor((Priority)log4jLevel)) {
            if (remote.booleanValue()) {
                MDC.put((String)"remote", (Object)remote.toString());
            }
            if (t == null) {
                t = LogFactory.extractThrowable(arguments);
            }
            this.logger.log(fqcn, (Priority)log4jLevel, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
        }
    }
}

