/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.log.dialect.log4j2;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.log.dialect.AbstractLog;
import com.aizuda.easy.retry.common.log.factory.LogFactory;
import org.apache.log4j.MDC;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;

public class Log4j2Log
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    public Log4j2Log(Logger logger) {
        this.logger = logger;
    }

    public Log4j2Log(Class<?> clazz) {
        this(LogManager.getLogger(clazz));
    }

    public Log4j2Log(String name) {
        this(LogManager.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.TRACE, t, format, remote, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.DEBUG, t, format, remote, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.INFO, t, format, remote, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.WARN, t, format, remote, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.ERROR, t, format, remote, arguments);
    }

    @Override
    public void log(String fqcn, com.aizuda.easy.retry.common.log.level.Level level, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, switch (level) {
            case com.aizuda.easy.retry.common.log.level.Level.TRACE -> Level.TRACE;
            case com.aizuda.easy.retry.common.log.level.Level.DEBUG -> Level.DEBUG;
            case com.aizuda.easy.retry.common.log.level.Level.INFO -> Level.INFO;
            case com.aizuda.easy.retry.common.log.level.Level.WARN -> Level.WARN;
            case com.aizuda.easy.retry.common.log.level.Level.ERROR -> Level.ERROR;
            default -> throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
        }, t, format, remote, arguments);
    }

    private void logIfEnabled(String fqcn, Level level, Throwable t, String msgTemplate, Boolean remote, Object ... arguments) {
        if (this.logger.isEnabled(level)) {
            if (remote.booleanValue()) {
                MDC.put((String)"remote", (Object)remote.toString());
            }
            if (this.logger instanceof AbstractLogger) {
                ((AbstractLogger)this.logger).logIfEnabled(fqcn, level, null, StrUtil.format((CharSequence)msgTemplate, (Object[])arguments), t);
            } else {
                if (t == null) {
                    t = LogFactory.extractThrowable(arguments);
                }
                this.logger.log(level, StrUtil.format((CharSequence)msgTemplate, (Object[])arguments), t);
            }
        }
    }
}

