/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.log.dialect.tinylog;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.log.dialect.AbstractLog;
import com.aizuda.easy.retry.common.log.level.Level;
import org.pmw.tinylog.LogEntryForwarder;
import org.pmw.tinylog.Logger;

public class TinyLog
extends AbstractLog {
    private static final long serialVersionUID = -4848042277045993735L;
    private static final int DEPTH = 4;
    private final int level;
    private final String name;

    public TinyLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public TinyLog(String name) {
        this.name = name;
        this.level = Logger.getLevel((String)name).ordinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= org.pmw.tinylog.Level.TRACE.ordinal();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.TRACE, t, format, remote, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= org.pmw.tinylog.Level.DEBUG.ordinal();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.DEBUG, t, format, remote, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level <= org.pmw.tinylog.Level.INFO.ordinal();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.INFO, t, format, remote, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= org.pmw.tinylog.Level.WARNING.ordinal();
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.WARNING, t, format, remote, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= org.pmw.tinylog.Level.ERROR.ordinal();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.ERROR, t, format, remote, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, this.toTinyLevel(level), t, format, remote, arguments);
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.level <= this.toTinyLevel(level).ordinal();
    }

    private void logIfEnabled(String fqcn, org.pmw.tinylog.Level level, Throwable t, String format, Boolean remote, Object ... arguments) {
        if (null == t) {
            t = TinyLog.getLastArgumentIfThrowable(arguments);
        }
        LogEntryForwarder.forward((int)4, (org.pmw.tinylog.Level)level, (Throwable)t, (String)StrUtil.toString((Object)format), (Object[])arguments);
    }

    private org.pmw.tinylog.Level toTinyLevel(Level level) {
        return switch (level) {
            case Level.TRACE -> org.pmw.tinylog.Level.TRACE;
            case Level.DEBUG -> org.pmw.tinylog.Level.DEBUG;
            case Level.INFO -> org.pmw.tinylog.Level.INFO;
            case Level.WARN -> org.pmw.tinylog.Level.WARNING;
            case Level.ERROR -> org.pmw.tinylog.Level.ERROR;
            case Level.OFF -> org.pmw.tinylog.Level.OFF;
            default -> throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
        };
    }

    private static Throwable getLastArgumentIfThrowable(Object ... arguments) {
        if (ArrayUtil.isNotEmpty((Object[])arguments) && arguments[arguments.length - 1] instanceof Throwable) {
            return (Throwable)arguments[arguments.length - 1];
        }
        return null;
    }
}

