/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.handler;

import akka.actor.ActorRef;
import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.common.core.constant.SystemConstants;
import com.aizuda.easy.retry.common.core.enums.JobOperationReasonEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskStatusEnum;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.akka.ActorGenerator;
import com.aizuda.easy.retry.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.easy.retry.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.easy.retry.server.job.task.support.JobTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.JobTaskStopHandler;
import com.aizuda.easy.retry.server.job.task.support.cache.MutableGraphCache;
import com.aizuda.easy.retry.server.job.task.support.stop.JobTaskStopFactory;
import com.aizuda.easy.retry.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.Job;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.graph.MutableGraph;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

@Component
public class WorkflowBatchHandler {
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final JobMapper jobMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;

    public boolean complete(Long workflowTaskBatchId) {
        return this.complete(workflowTaskBatchId, null);
    }

    public boolean complete(Long workflowTaskBatchId, WorkflowTaskBatch workflowTaskBatch) {
        workflowTaskBatch = Optional.ofNullable(workflowTaskBatch).orElseGet(() -> (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)workflowTaskBatchId));
        Assert.notNull((Object)workflowTaskBatch, () -> new EasyRetryServerException("\u4efb\u52a1\u4e0d\u5b58\u5728"));
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph<Long> graph = MutableGraphCache.getOrDefault(workflowTaskBatchId, flowInfo);
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatch.getId())).in(JobTaskBatch::getWorkflowNodeId, (Collection)graph.nodes()));
        if (CollectionUtils.isEmpty((Collection)jobTaskBatches)) {
            return false;
        }
        if (jobTaskBatches.stream().anyMatch(jobTaskBatch -> JobTaskBatchStatusEnum.NOT_COMPLETE.contains(jobTaskBatch.getTaskBatchStatus()))) {
            return false;
        }
        Map<Long, List<JobTaskBatch>> currentWorkflowNodeMap = jobTaskBatches.stream().collect(Collectors.groupingBy(JobTaskBatch::getWorkflowNodeId));
        int taskStatus = JobTaskBatchStatusEnum.SUCCESS.getStatus();
        int operationReason = JobOperationReasonEnum.NONE.getReason();
        List<Long> leaves = MutableGraphCache.getLeaves(workflowTaskBatchId, flowInfo);
        for (Long leaf : leaves) {
            boolean isNeedProcess;
            List<JobTaskBatch> jobTaskBatchList = currentWorkflowNodeMap.getOrDefault(leaf, Lists.newArrayList());
            if (CollectionUtils.isEmpty(jobTaskBatchList) && (isNeedProcess = WorkflowBatchHandler.checkLeafCompleted(graph, currentWorkflowNodeMap, graph.predecessors((Object)leaf)))) {
                return false;
            }
            boolean isMatchSuccess = jobTaskBatchList.stream().anyMatch(jobTaskBatch -> JobTaskStatusEnum.SUCCESS.getStatus() == jobTaskBatch.getTaskBatchStatus().intValue());
            if (isMatchSuccess) continue;
            for (JobTaskBatch jobTaskBatch2 : jobTaskBatchList) {
                if (jobTaskBatch2.getTaskBatchStatus().intValue() == JobTaskBatchStatusEnum.SUCCESS.getStatus()) break;
                if (!JobTaskBatchStatusEnum.NOT_SUCCESS.contains(jobTaskBatch2.getTaskBatchStatus()) || JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason() == jobTaskBatch2.getOperationReason().intValue() || JobOperationReasonEnum.WORKFLOW_NODE_CLOSED_SKIP_EXECUTION.getReason() == jobTaskBatch2.getOperationReason().intValue()) continue;
                taskStatus = JobTaskBatchStatusEnum.FAIL.getStatus();
            }
        }
        this.handlerTaskBatch(workflowTaskBatchId, taskStatus, operationReason);
        return true;
    }

    private static boolean checkLeafCompleted(MutableGraph<Long> graph, Map<Long, List<JobTaskBatch>> currentWorkflowNodeMap, Set<Long> parentIds) {
        boolean isNeedProcess = true;
        for (Long nodeId : parentIds) {
            List<JobTaskBatch> jobTaskBatchList = currentWorkflowNodeMap.get(nodeId);
            if (CollectionUtils.isEmpty(jobTaskBatchList)) {
                isNeedProcess = isNeedProcess || WorkflowBatchHandler.checkLeafCompleted(graph, currentWorkflowNodeMap, graph.predecessors((Object)nodeId));
                continue;
            }
            for (JobTaskBatch jobTaskBatch : jobTaskBatchList) {
                if (JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(jobTaskBatch.getOperationReason())) {
                    isNeedProcess = false;
                    continue;
                }
                isNeedProcess = true;
            }
        }
        return isNeedProcess;
    }

    private void handlerTaskBatch(Long workflowTaskBatchId, int taskStatus, int operationReason) {
        WorkflowTaskBatch jobTaskBatch = new WorkflowTaskBatch();
        jobTaskBatch.setId(workflowTaskBatchId);
        jobTaskBatch.setTaskBatchStatus(Integer.valueOf(taskStatus));
        jobTaskBatch.setOperationReason(Integer.valueOf(operationReason));
        this.workflowTaskBatchMapper.updateById((Object)jobTaskBatch);
    }

    public void stop(Long workflowTaskBatchId, Integer operationReason) {
        if (Objects.isNull(operationReason) || operationReason.intValue() == JobOperationReasonEnum.NONE.getReason()) {
            operationReason = JobOperationReasonEnum.JOB_OVERLAY.getReason();
        }
        WorkflowTaskBatch workflowTaskBatch = new WorkflowTaskBatch();
        workflowTaskBatch.setTaskBatchStatus(Integer.valueOf(JobTaskBatchStatusEnum.STOP.getStatus()));
        workflowTaskBatch.setOperationReason(operationReason);
        workflowTaskBatch.setId(workflowTaskBatchId);
        Assert.isTrue((1 == this.workflowTaskBatchMapper.updateById((Object)workflowTaskBatch) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u505c\u6b62\u5de5\u4f5c\u6d41\u6279\u6b21\u5931\u8d25. id:[{}]", new Object[]{workflowTaskBatchId}));
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_COMPLETE)).eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatchId));
        if (CollectionUtils.isEmpty((Collection)jobTaskBatches)) {
            return;
        }
        List jobs = this.jobMapper.selectBatchIds((Collection)jobTaskBatches.stream().map(JobTaskBatch::getJobId).collect(Collectors.toSet()));
        Map<Long, Job> jobMap = jobs.stream().collect(Collectors.toMap(Job::getId, i -> i));
        for (JobTaskBatch jobTaskBatch : jobTaskBatches) {
            Job job = jobMap.get(jobTaskBatch.getJobId());
            if (!Objects.nonNull(job)) continue;
            JobTaskStopHandler instanceInterrupt = JobTaskStopFactory.getJobTaskStop(job.getTaskType());
            TaskStopJobContext stopJobContext = JobTaskConverter.INSTANCE.toStopJobContext(job);
            stopJobContext.setTaskBatchId(jobTaskBatch.getId());
            stopJobContext.setJobOperationReason(JobOperationReasonEnum.JOB_TASK_INTERRUPTED.getReason());
            stopJobContext.setNeedUpdateTaskStatus(Boolean.TRUE);
            stopJobContext.setForceStop(Boolean.TRUE);
            instanceInterrupt.stop(stopJobContext);
        }
    }

    public void checkWorkflowExecutor(Long workflowTaskBatchId, WorkflowTaskBatch workflowTaskBatch) throws IOException {
        workflowTaskBatch = Optional.ofNullable(workflowTaskBatch).orElseGet(() -> (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)workflowTaskBatchId));
        Assert.notNull((Object)workflowTaskBatch, () -> new EasyRetryServerException("\u4efb\u52a1\u4e0d\u5b58\u5728"));
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph<Long> graph = MutableGraphCache.getOrDefault(workflowTaskBatchId, flowInfo);
        Set successors = graph.successors((Object)SystemConstants.ROOT);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return;
        }
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatchId)).in(JobTaskBatch::getWorkflowNodeId, (Collection)graph.nodes())).orderByDesc(JobTaskBatch::getId));
        Map<Long, JobTaskBatch> jobTaskBatchMap = jobTaskBatches.stream().collect(Collectors.toMap(JobTaskBatch::getWorkflowNodeId, i -> i, (i, j) -> i));
        this.checkWorkflowExecutor(SystemConstants.ROOT, workflowTaskBatchId, graph, jobTaskBatchMap);
    }

    private void checkWorkflowExecutor(Long parentId, Long workflowTaskBatchId, MutableGraph<Long> graph, Map<Long, JobTaskBatch> jobTaskBatchMap) {
        JobTaskBatch parentJobTaskBatch = jobTaskBatchMap.get(parentId);
        if (Objects.nonNull(parentJobTaskBatch) && JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(parentJobTaskBatch.getOperationReason())) {
            return;
        }
        Set successors = graph.successors((Object)parentId);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return;
        }
        for (Long successor : successors) {
            JobTaskBatch jobTaskBatch = jobTaskBatchMap.get(successor);
            if (Objects.isNull(jobTaskBatch)) {
                WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
                taskExecuteDTO.setWorkflowTaskBatchId(workflowTaskBatchId);
                taskExecuteDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_WORKFLOW.getType());
                taskExecuteDTO.setParentId(parentId);
                if (Objects.nonNull(parentJobTaskBatch)) {
                    taskExecuteDTO.setTaskBatchId(parentJobTaskBatch.getId());
                }
                this.openNextNode(taskExecuteDTO);
                break;
            }
            if (JobTaskBatchStatusEnum.NOT_COMPLETE.contains(jobTaskBatch.getTaskBatchStatus())) {
                Job job = (Job)this.jobMapper.selectById((Serializable)jobTaskBatch.getJobId());
                JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(job);
                jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_WORKFLOW.getType());
                jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli() + DateUtils.toNowMilli() % 1000L);
                jobTaskPrepare.setWorkflowTaskBatchId(workflowTaskBatchId);
                jobTaskPrepare.setWorkflowNodeId(successor);
                jobTaskPrepare.setParentWorkflowNodeId(parentId);
                ActorRef actorRef = ActorGenerator.jobTaskPrepareActor();
                actorRef.tell((Object)jobTaskPrepare, actorRef);
                break;
            }
            this.checkWorkflowExecutor(successor, workflowTaskBatchId, graph, jobTaskBatchMap);
        }
    }

    public void openNextNode(final WorkflowNodeTaskExecuteDTO taskExecuteDTO) {
        if (Objects.isNull(taskExecuteDTO.getParentId()) || Objects.isNull(taskExecuteDTO.getWorkflowTaskBatchId())) {
            return;
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    WorkflowBatchHandler.this.tellWorkflowTaskExecutor(taskExecuteDTO);
                }
            });
        } else {
            this.tellWorkflowTaskExecutor(taskExecuteDTO);
        }
    }

    private void tellWorkflowTaskExecutor(WorkflowNodeTaskExecuteDTO taskExecuteDTO) {
        try {
            ActorRef actorRef = ActorGenerator.workflowTaskExecutorActor();
            actorRef.tell((Object)taskExecuteDTO, actorRef);
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\u5931\u8d25", new Object[]{e});
        }
    }

    public WorkflowBatchHandler(WorkflowTaskBatchMapper workflowTaskBatchMapper, JobMapper jobMapper, JobTaskBatchMapper jobTaskBatchMapper) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.jobMapper = jobMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
    }
}

