/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.listener;

import com.aizuda.easy.retry.common.core.alarm.AlarmContext;
import com.aizuda.easy.retry.common.core.enums.JobNotifySceneEnum;
import com.aizuda.easy.retry.common.core.util.EnvironmentUtils;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.AlarmInfoConverter;
import com.aizuda.easy.retry.server.common.alarm.AbstractJobAlarm;
import com.aizuda.easy.retry.server.common.dto.JobAlarmInfo;
import com.aizuda.easy.retry.server.common.dto.NotifyConfigInfo;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.job.task.support.event.JobTaskFailAlarmEvent;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobTaskFailAlarmListener
extends AbstractJobAlarm<JobTaskFailAlarmEvent> {
    private static final Logger log = LoggerFactory.getLogger(JobTaskFailAlarmListener.class);
    @Autowired
    private JobTaskBatchMapper jobTaskBatchMapper;
    private LinkedBlockingQueue<Long> queue = new LinkedBlockingQueue(1000);
    private static String jobTaskFailTextMessagesFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 Job\u4efb\u52a1\u6267\u884c\u5931\u8d25</font> \n> \u7a7a\u95f4ID:{}  \n> \u7ec4\u540d\u79f0:{}  \n> \u4efb\u52a1\u540d\u79f0:{}  \n> \u6267\u884c\u5668\u540d\u79f0:{}  \n> \u65b9\u6cd5\u53c2\u6570:{}  \n> \u65f6\u95f4:{}  \n";

    protected List<JobAlarmInfo> poll() throws InterruptedException {
        Long jobTaskBatchId = this.queue.take();
        ArrayList jobTaskBatchIds = Lists.newArrayList((Object[])new Long[]{jobTaskBatchId});
        this.queue.drainTo(jobTaskBatchIds, 200);
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"a.id", (Collection)jobTaskBatchIds)).eq((Object)"a.deleted", (Object)0);
        List jobTaskBatchList = this.jobTaskBatchMapper.selectJobBatchListByIds((Wrapper)wrapper);
        return AlarmInfoConverter.INSTANCE.toJobAlarmInfos(jobTaskBatchList);
    }

    protected AlarmContext buildAlarmContext(JobAlarmInfo alarmDTO, NotifyConfigInfo notifyConfig) {
        return AlarmContext.build().text(jobTaskFailTextMessagesFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), alarmDTO.getNamespaceId(), alarmDTO.getGroupName(), alarmDTO.getJobName(), alarmDTO.getExecutorInfo(), alarmDTO.getArgsStr(), DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN)}).title("{}\u73af\u5883 JOB\u4efb\u52a1\u5931\u8d25", new Object[]{EnvironmentUtils.getActiveProfile()}).notifyAttribute(notifyConfig.getNotifyAttribute());
    }

    protected void startLog() {
        EasyRetryLog.LOCAL.info("JobTaskFailAlarmListener started", new Object[0]);
    }

    protected int getNotifyScene() {
        return JobNotifySceneEnum.JOB_TASK_ERROR.getNotifyScene();
    }

    public void onApplicationEvent(JobTaskFailAlarmEvent event) {
        if (!this.queue.offer(event.getJobTaskBatchId())) {
            EasyRetryLog.LOCAL.warn("JOB\u4efb\u52a1\u6267\u884c\u5931\u8d25\u544a\u8b66\u961f\u5217\u5df2\u6ee1", new Object[0]);
        }
    }
}

