/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.log;

import akka.actor.ActorRef;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.dto.LogContentDTO;
import com.aizuda.easy.retry.common.log.dto.TaskLogFieldDTO;
import com.aizuda.easy.retry.common.log.enums.LogTypeEnum;
import com.aizuda.easy.retry.server.common.LogStorage;
import com.aizuda.easy.retry.server.common.akka.ActorGenerator;
import com.aizuda.easy.retry.server.common.dto.JobLogMetaDTO;
import com.aizuda.easy.retry.server.common.dto.LogMetaDTO;
import com.aizuda.easy.retry.server.common.log.LogStorageFactory;
import com.aizuda.easy.retry.server.job.task.dto.JobLogDTO;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class JobLogStorage
implements LogStorage,
InitializingBean {
    public LogTypeEnum logType() {
        return LogTypeEnum.JOB;
    }

    public void storage(LogContentDTO logContentDTO, LogMetaDTO logMetaDTO) {
        JobLogMetaDTO jobLogMetaDTO = (JobLogMetaDTO)logMetaDTO;
        JobLogDTO jobLogDTO = new JobLogDTO();
        Map<String, String> messageMap = logContentDTO.getFieldList().stream().filter(logTaskDTO_ -> !Objects.isNull(logTaskDTO_.getValue())).collect(Collectors.toMap(TaskLogFieldDTO::getName, TaskLogFieldDTO::getValue));
        jobLogDTO.setMessage(JsonUtil.toJsonString((Object)Lists.newArrayList((Object[])new Map[]{messageMap})));
        jobLogDTO.setTaskId(jobLogMetaDTO.getTaskId());
        jobLogDTO.setJobId(jobLogMetaDTO.getJobId());
        jobLogDTO.setGroupName(logMetaDTO.getGroupName());
        jobLogDTO.setNamespaceId(logMetaDTO.getNamespaceId());
        jobLogDTO.setTaskBatchId(jobLogMetaDTO.getTaskBatchId());
        jobLogDTO.setRealTime(logContentDTO.getTimeStamp());
        ActorRef actorRef = ActorGenerator.jobLogActor();
        actorRef.tell((Object)jobLogDTO, actorRef);
    }

    public void afterPropertiesSet() throws Exception {
        LogStorageFactory.register((LogTypeEnum)this.logType(), (LogStorage)this);
    }
}

