/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.prepare.job;

import com.aizuda.easy.retry.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.easy.retry.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.easy.retry.server.job.task.dto.JobTimerTaskDTO;
import com.aizuda.easy.retry.server.job.task.support.prepare.job.AbstractJobPrePareHandler;
import com.aizuda.easy.retry.server.job.task.support.timer.JobTimerTask;
import com.aizuda.easy.retry.server.job.task.support.timer.JobTimerWheel;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WaitJobPrepareHandler
extends AbstractJobPrePareHandler {
    private static final Logger log = LoggerFactory.getLogger(WaitJobPrepareHandler.class);

    @Override
    public boolean matches(Integer status) {
        return JobTaskBatchStatusEnum.WAITING.getStatus() == status.intValue();
    }

    @Override
    protected void doHandler(JobTaskPrepareDTO jobPrepareDTO) {
        log.debug("\u5b58\u5728\u5f85\u5904\u7406\u4efb\u52a1. taskBatchId:[{}]", (Object)jobPrepareDTO.getTaskBatchId());
        if (!JobTimerWheel.isExisted(SyetemTaskTypeEnum.JOB.getType(), jobPrepareDTO.getTaskBatchId())) {
            log.info("\u5b58\u5728\u5f85\u5904\u7406\u4efb\u52a1\u4e14\u65f6\u95f4\u8f6e\u4e2d\u4e0d\u5b58\u5728 taskBatchId:[{}]", (Object)jobPrepareDTO.getTaskBatchId());
            long delay = jobPrepareDTO.getNextTriggerAt() - DateUtils.toNowMilli();
            JobTimerTaskDTO jobTimerTaskDTO = new JobTimerTaskDTO();
            jobTimerTaskDTO.setTaskBatchId(jobPrepareDTO.getTaskBatchId());
            jobTimerTaskDTO.setJobId(jobPrepareDTO.getJobId());
            JobTimerWheel.register(SyetemTaskTypeEnum.JOB.getType(), jobPrepareDTO.getTaskBatchId(), new JobTimerTask(jobTimerTaskDTO), delay, TimeUnit.MILLISECONDS);
        }
    }
}

