/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.prepare.workflow;

import com.aizuda.easy.retry.common.core.enums.JobOperationReasonEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.job.task.dto.WorkflowTaskPrepareDTO;
import com.aizuda.easy.retry.server.job.task.enums.BlockStrategyEnum;
import com.aizuda.easy.retry.server.job.task.support.BlockStrategy;
import com.aizuda.easy.retry.server.job.task.support.WorkflowTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.block.workflow.WorkflowBlockStrategyContext;
import com.aizuda.easy.retry.server.job.task.support.block.workflow.WorkflowBlockStrategyFactory;
import com.aizuda.easy.retry.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.easy.retry.server.job.task.support.prepare.workflow.AbstractWorkflowPrePareHandler;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RunningWorkflowPrepareHandler
extends AbstractWorkflowPrePareHandler {
    private static final Logger log = LoggerFactory.getLogger(RunningWorkflowPrepareHandler.class);
    private final WorkflowBatchHandler workflowBatchHandler;

    @Override
    public boolean matches(Integer status) {
        return Objects.nonNull(status) && JobTaskBatchStatusEnum.RUNNING.getStatus() == status.intValue();
    }

    @Override
    protected void doHandler(WorkflowTaskPrepareDTO prepare) {
        log.debug("\u5b58\u5728\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1. prepare:[{}]", (Object)JsonUtil.toJsonString((Object)prepare));
        int blockStrategy = prepare.getBlockStrategy();
        if (this.workflowBatchHandler.complete(prepare.getWorkflowTaskBatchId())) {
            blockStrategy = BlockStrategyEnum.CONCURRENCY.getBlockStrategy();
        } else {
            long delay = DateUtils.toNowMilli() - prepare.getExecutionAt();
            if (delay > DateUtils.toEpochMilli((long)prepare.getExecutorTimeout().intValue())) {
                log.info("\u4efb\u52a1\u6267\u884c\u8d85\u65f6.workflowTaskBatchId:[{}] delay:[{}] executorTimeout:[{}]", new Object[]{prepare.getWorkflowTaskBatchId(), delay, DateUtils.toEpochMilli((long)prepare.getExecutorTimeout().intValue())});
                this.workflowBatchHandler.stop(prepare.getWorkflowTaskBatchId(), JobOperationReasonEnum.TASK_EXECUTION_TIMEOUT.getReason());
            }
        }
        if (prepare.isOnlyTimeoutCheck()) {
            return;
        }
        BlockStrategy blockStrategyInterface = WorkflowBlockStrategyFactory.getBlockStrategy(blockStrategy);
        WorkflowBlockStrategyContext workflowBlockStrategyContext = WorkflowTaskConverter.INSTANCE.toWorkflowBlockStrategyContext(prepare);
        blockStrategyInterface.block(workflowBlockStrategyContext);
    }

    public RunningWorkflowPrepareHandler(WorkflowBatchHandler workflowBatchHandler) {
        this.workflowBatchHandler = workflowBatchHandler;
    }
}

