/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.stop;

import akka.actor.ActorRef;
import com.aizuda.easy.retry.common.core.enums.JobTaskTypeEnum;
import com.aizuda.easy.retry.server.common.akka.ActorGenerator;
import com.aizuda.easy.retry.server.common.util.ClientInfoUtils;
import com.aizuda.easy.retry.server.job.task.dto.RealStopTaskInstanceDTO;
import com.aizuda.easy.retry.server.job.task.support.JobTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.stop.AbstractJobTaskStopHandler;
import com.aizuda.easy.retry.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BroadcastTaskStopHandler
extends AbstractJobTaskStopHandler {
    private static final Logger log = LoggerFactory.getLogger(BroadcastTaskStopHandler.class);

    @Override
    public JobTaskTypeEnum getTaskType() {
        return JobTaskTypeEnum.BROADCAST;
    }

    @Override
    public void doStop(TaskStopJobContext context) {
        for (JobTask jobTask : context.getJobTasks()) {
            RealStopTaskInstanceDTO taskInstanceDTO = JobTaskConverter.INSTANCE.toRealStopTaskInstanceDTO(context);
            taskInstanceDTO.setClientId(ClientInfoUtils.clientId((String)jobTask.getClientInfo()));
            ActorRef actorRef = ActorGenerator.jobRealStopTaskInstanceActor();
            actorRef.tell((Object)taskInstanceDTO, actorRef);
        }
    }
}

