/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.timer;

import akka.actor.ActorRef;
import com.aizuda.easy.retry.common.core.constant.SystemConstants;
import com.aizuda.easy.retry.server.common.akka.ActorGenerator;
import com.aizuda.easy.retry.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.easy.retry.server.job.task.dto.WorkflowTimerTaskDTO;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowTimerTask
implements TimerTask {
    private static final Logger log = LoggerFactory.getLogger(WorkflowTimerTask.class);
    private WorkflowTimerTaskDTO workflowTimerTaskDTO;

    public void run(Timeout timeout) throws Exception {
        log.debug("\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u8c03\u5ea6. \u5f53\u524d\u65f6\u95f4:[{}] taskId:[{}]", (Object)LocalDateTime.now(), (Object)this.workflowTimerTaskDTO.getWorkflowTaskBatchId());
        try {
            WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
            taskExecuteDTO.setWorkflowTaskBatchId(this.workflowTimerTaskDTO.getWorkflowTaskBatchId());
            taskExecuteDTO.setTaskExecutorScene(this.workflowTimerTaskDTO.getTaskExecutorScene());
            taskExecuteDTO.setParentId(SystemConstants.ROOT);
            ActorRef actorRef = ActorGenerator.workflowTaskExecutorActor();
            actorRef.tell((Object)taskExecuteDTO, actorRef);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    public WorkflowTimerTask(WorkflowTimerTaskDTO workflowTimerTaskDTO) {
        this.workflowTimerTaskDTO = workflowTimerTaskDTO;
    }
}

