/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.filter;

import com.aizuda.easy.security.HandlerFactory;
import com.aizuda.easy.security.domain.LocalEntity;
import com.aizuda.easy.security.exp.impl.BasicException;
import com.aizuda.easy.security.filter.wrapper.RepWrapper;
import com.aizuda.easy.security.filter.wrapper.ReqWrapper;
import com.aizuda.easy.security.properties.SecurityProperties;
import com.aizuda.easy.security.util.CheckUtil;
import com.aizuda.easy.security.util.LocalUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class FunctionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FunctionFilter.class);
    private final SecurityProperties properties;
    private final HandlerFactory factory;
    private final HandlerExceptionResolver handlerExceptionResolver;
    public static final String URI = "uri";

    public FunctionFilter(SecurityProperties properties, HandlerFactory factory, HandlerExceptionResolver handlerExceptionResolver) {
        this.properties = properties;
        this.factory = factory;
        this.handlerExceptionResolver = handlerExceptionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object request = (HttpServletRequest)servletRequest;
        Object response = (HttpServletResponse)servletResponse;
        request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        try {
            String accept = request.getHeader("Accept");
            log.debug("url:{},method:{},type:{},Accept:{}", new Object[]{request.getRequestURI(), request.getMethod(), request.getContentType(), accept});
            LocalUtil.create();
            this.specialPathHandler((HttpServletRequest)request);
            request = new ReqWrapper((HttpServletRequest)request, this.factory);
            if (accept != null && accept.contains("application/json")) {
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                response = new RepWrapper((HttpServletResponse)response, this.factory);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            response.setHeader(URI, request.getRequestURI());
            if (response instanceof RepWrapper) {
                ((RepWrapper)((Object)response)).changeContent();
            }
        }
        catch (BasicException e) {
            log.error("{},{}", (Object)e.getMsg(), (Object)request.getRequestURI());
            this.handlerExceptionResolver.resolveException(request, response, null, (Exception)e);
        }
        finally {
            LocalUtil.destroy();
        }
    }

    private void specialPathHandler(HttpServletRequest request) {
        LocalEntity localEntity = LocalUtil.getLocalEntity();
        List<String> urlFilter = this.properties.getSpecialUrl();
        String url = request.getRequestURI();
        CheckUtil.pathMatch(urlFilter, url, localEntity::setSpecial);
    }
}

