/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.filter.wrapper;

import com.aizuda.easy.security.HandlerFactory;
import com.aizuda.easy.security.handler.FunctionHandler;
import com.aizuda.easy.security.handler.RepFunctionHandler;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepSSEWrapper
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(RepSSEWrapper.class);
    private final SseServletOutputStream outputStream;
    private PrintWriter writer;
    private HandlerFactory factory;
    private HttpServletResponse response;

    public RepSSEWrapper(HttpServletResponse response, HandlerFactory factory) throws IOException {
        super(response);
        this.response = response;
        this.outputStream = new SseServletOutputStream(response.getOutputStream());
        this.factory = factory;
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.outputStream), StandardCharsets.UTF_8));
        }
        return this.writer;
    }

    class SseServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream originalStream;

        public SseServletOutputStream(ServletOutputStream originalStream) {
            this.originalStream = originalStream;
        }

        public boolean isReady() {
            return this.originalStream.isReady();
        }

        public void setWriteListener(WriteListener listener) {
            this.originalStream.setWriteListener(listener);
        }

        public void write(int b) throws IOException {
            this.originalStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String originalData = new String(b, off, len, StandardCharsets.UTF_8);
            String modifiedData = this.modifySseData(originalData);
            byte[] modifiedBytes = modifiedData.getBytes(StandardCharsets.UTF_8);
            this.originalStream.write(modifiedBytes);
        }

        private String modifySseData(String body) throws IOException {
            for (FunctionHandler functionHandler : RepSSEWrapper.this.factory.getFunctionHandlers()) {
                if (!(functionHandler instanceof RepFunctionHandler)) continue;
                log.debug("exec handler : {}", (Object)functionHandler.getClass().getName());
                body = ((RepFunctionHandler)functionHandler).exec(RepSSEWrapper.this.response, body);
            }
            return body;
        }
    }
}

