/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.filter.wrapper;

import com.aizuda.easy.security.HandlerFactory;
import com.aizuda.easy.security.exp.impl.BasicException;
import com.aizuda.easy.security.handler.FunctionHandler;
import com.aizuda.easy.security.handler.RepFunctionHandler;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class RepWrapper
extends ContentCachingResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(RepWrapper.class);
    private HttpServletResponse response;
    private HandlerFactory factory;

    public RepWrapper(HttpServletResponse response, HandlerFactory factory) {
        super(response);
        this.response = response;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeContent() throws IOException, BasicException {
        String body = new String(this.getContentAsByteArray(), this.getCharacterEncoding());
        try {
            for (FunctionHandler functionHandler : this.factory.getFunctionHandlers()) {
                if (!(functionHandler instanceof RepFunctionHandler)) continue;
                log.debug("exec handler : {}", (Object)functionHandler.getClass().getName());
                body = ((RepFunctionHandler)functionHandler).exec(this.response, body);
            }
        }
        finally {
            if (!this.isCommitted()) {
                this.resetBuffer();
            }
            byte[] modifiedContent = body.getBytes(this.getCharacterEncoding());
            this.setContentLength(modifiedContent.length);
            this.getOutputStream().write(modifiedContent);
            this.copyBodyToResponse();
        }
    }
}

