/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.filter.wrapper;

import com.aizuda.easy.security.HandlerFactory;
import com.aizuda.easy.security.exp.impl.BasicException;
import com.aizuda.easy.security.handler.FunctionHandler;
import com.aizuda.easy.security.handler.ReqFunctionHandler;
import com.aizuda.easy.security.util.CheckUtil;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(ReqWrapper.class);
    private String body;

    public ReqWrapper(HttpServletRequest request, HandlerFactory factory) throws IOException, BasicException {
        super(request);
        this.body = this.getBodyContent(request);
        for (FunctionHandler functionHandler : factory.getFunctionHandlers()) {
            if (!(functionHandler instanceof ReqFunctionHandler)) continue;
            log.debug("exec handler : {}", (Object)functionHandler.getClass().getName());
            this.body = ((ReqFunctionHandler)functionHandler).exec(request, this.body);
        }
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body.getBytes(StandardCharsets.UTF_8));
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    private String getBodyContent(HttpServletRequest request) throws IOException {
        String line;
        if (CheckUtil.reqSkip(request)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = request.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }
}

