/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.handler.exec;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.security.code.BasicCode;
import com.aizuda.easy.security.domain.LocalEntity;
import com.aizuda.easy.security.exp.impl.AuthenticationException;
import com.aizuda.easy.security.exp.impl.AuthorizationException;
import com.aizuda.easy.security.handler.AbstractFunctionHandler;
import com.aizuda.easy.security.handler.ReqFunctionHandler;
import com.aizuda.easy.security.util.LocalUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AuthorizationHandler
extends AbstractFunctionHandler
implements ReqFunctionHandler {
    @Override
    public String exec(HttpServletRequest request, String json) {
        LocalEntity localEntity = LocalUtil.getLocalEntity();
        if (localEntity.getSpecial().booleanValue() || !this.properties.getAuthorizeEnable()) {
            return json;
        }
        String token = request.getHeader(this.properties.getTokenKey());
        if (StrUtil.isEmpty((CharSequence)token)) {
            throw new AuthenticationException(BasicCode.BASIC_CODE_401, request.getRequestURI());
        }
        List<String> list = this.easySecurityServer.getAuthorizeUrl(token);
        if (CollectionUtil.isEmpty(list)) {
            throw new AuthorizationException(BasicCode.BASIC_CODE_403, request.getRequestURI());
        }
        String url = request.getRequestURI();
        if (!list.contains(url)) {
            throw new AuthorizationException(BasicCode.BASIC_CODE_403, request.getRequestURI());
        }
        return json;
    }

    @Override
    public Integer getIndex() {
        return -2147483608;
    }
}

