/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.handler.exec;

import com.aizuda.easy.security.code.BasicCode;
import com.aizuda.easy.security.exp.impl.BasicException;
import com.aizuda.easy.security.handler.AbstractFunctionHandler;
import com.aizuda.easy.security.handler.ReqFunctionHandler;
import com.aizuda.easy.security.util.IPUtil;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BlacklistHandler
extends AbstractFunctionHandler
implements ReqFunctionHandler {
    private static final Logger log = LoggerFactory.getLogger(BlacklistHandler.class);

    @Override
    public String exec(HttpServletRequest request, String json) {
        String clientIP = IPUtil.getIp(request);
        log.debug("Accessing the user's IP: {}", (Object)clientIP);
        if (this.properties.getBlackList().contains(clientIP)) {
            throw new BasicException(BasicCode.BASIC_CODE_99984, clientIP);
        }
        return json;
    }

    @Override
    public Integer getIndex() {
        return -2147483638;
    }
}

