/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.server.encryption;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.security.code.BasicCode;
import com.aizuda.easy.security.exp.impl.BasicException;
import com.aizuda.easy.security.util.AesEncryptUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;

public interface CiphertextServer {
    public static final String IV = "iv";

    default public String encryption(HttpServletResponse response, String json, String key) throws BasicException {
        String iv = this.getIvValue();
        response.setHeader(IV, iv);
        json = AesEncryptUtil.encryption(json, key, iv);
        if (StrUtil.isEmpty((CharSequence)json)) {
            throw new BasicException(BasicCode.BASIC_CODE_99988, new Object[0]);
        }
        return json.trim();
    }

    default public String decryption(HttpServletRequest request, String json, String key) throws BasicException {
        if (StrUtil.isEmpty((CharSequence)key)) {
            throw new BasicException(BasicCode.BASIC_CODE_99990, new Object[0]);
        }
        String iv = request.getHeader(IV);
        if (StrUtil.isEmpty((CharSequence)iv)) {
            throw new BasicException(BasicCode.BASIC_CODE_99989, new Object[0]);
        }
        if (StrUtil.isEmpty((CharSequence)(json = AesEncryptUtil.decryption(json, key, iv)))) {
            throw new BasicException(BasicCode.BASIC_CODE_99987, new Object[0]);
        }
        return json;
    }

    default public String getIvValue() {
        return UUID.randomUUID().toString().replace("-", "").substring(16);
    }

    default public String getIV() {
        return IV;
    }
}

