/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.util;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;

public class AesEncryptUtil {
    private static final String INSTANCE = "AES/CBC/NoPadding";
    private static final String ALGORITHM = "AES";

    public static String encryption(String data, String key, String iv) {
        try {
            Cipher cipher = Cipher.getInstance(INSTANCE);
            int blockSize = cipher.getBlockSize();
            byte[] dataBytes = data.getBytes();
            int plaintextLength = dataBytes.length;
            if (plaintextLength % blockSize != 0) {
                plaintextLength += blockSize - plaintextLength % blockSize;
            }
            byte[] plaintext = new byte[plaintextLength];
            System.arraycopy(dataBytes, 0, plaintext, 0, dataBytes.length);
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(iv.getBytes());
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] encrypted = cipher.doFinal(plaintext);
            return new Base64().encodeToString(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryption(String data, String key, String iv) {
        try {
            byte[] encrypted1 = new Base64().decode(data);
            Cipher cipher = Cipher.getInstance(INSTANCE);
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(iv.getBytes());
            cipher.init(2, (Key)keySpec, ivSpec);
            byte[] original = cipher.doFinal(encrypted1);
            return new String(original, Charsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

