/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.security.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.function.Consumer;

public class CheckUtil {
    private static final String RULE_0 = "**";
    private static final String RULE_1 = "/";

    public static boolean pathMatch(List<String> configureUrl, String url, Consumer<Boolean> consumer) {
        boolean b = CheckUtil.isMatch(configureUrl, url);
        if (b) {
            consumer.accept(b);
        }
        return b;
    }

    public static Boolean isMatch(List<String> configureUrl, String url) {
        return configureUrl.stream().anyMatch(i -> {
            String ir = i.replace(RULE_0, "");
            return i.equals(url) || i.endsWith(RULE_0) && url.startsWith(ir) || ir.equals(url + RULE_1);
        });
    }

    public static boolean reqSkip(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType == null || !contentType.contains("application/json");
    }

    public static boolean repSkip(HttpServletResponse response) {
        String contentType = response.getContentType();
        return contentType == null || !contentType.contains("application/json");
    }
}

