/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobRemoteException;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcResult;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcSnailJobRequest;
import com.aizuda.snailjob.common.core.grpc.auto.Metadata;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ClientCalls;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.boot.autoconfigure.web.ServerProperties;

public final class GrpcChannel {
    private static ManagedChannel channel;
    private static final String SNAIL_JOB_SERVER_PORT = "snail-job.server.port";
    private static final String SNAIL_JOB_SERVER_HOST = "snail-job.server.host";
    private static final String SNAIL_JOB_CLIENT_PORT = "snail-job.port";
    private static final String SNAIL_JOB_CLIENT_HOST = "snail-job.host";
    private static final Integer MIN_PORT;
    private static final Integer MAX_PORT;
    private static final ReentrantLock PORT_LOCK;
    private static final Integer RANDOM_CLIENT_PORT;
    private static final String HOST_ID;
    private static final int PORT;
    private static final String HOST;

    public static void setChannel(ManagedChannel channel) {
        GrpcChannel.channel = channel;
    }

    public static int getServerPort() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getContext().getBean(SnailJobProperties.class);
        SnailJobProperties.ServerConfig serverConfig = snailJobProperties.getServer();
        String port = System.getProperty(SNAIL_JOB_SERVER_PORT);
        if (StrUtil.isBlank((CharSequence)port)) {
            System.setProperty(SNAIL_JOB_SERVER_PORT, String.valueOf(serverConfig.getPort()));
        }
        return Integer.parseInt(System.getProperty(SNAIL_JOB_SERVER_PORT));
    }

    public static String getServerHost() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        SnailJobProperties.ServerConfig serverConfig = snailJobProperties.getServer();
        String host = System.getProperty(SNAIL_JOB_SERVER_HOST);
        if (StrUtil.isBlank((CharSequence)host)) {
            System.setProperty(SNAIL_JOB_SERVER_HOST, serverConfig.getHost());
        }
        return System.getProperty(SNAIL_JOB_SERVER_HOST);
    }

    public static String getClientHost() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        String host = snailJobProperties.getHost();
        if (StrUtil.isBlank((CharSequence)host)) {
            host = HOST;
        }
        return host;
    }

    public static Integer getClientPort() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        ServerProperties serverProperties = (ServerProperties)SnailSpringContext.getBean(ServerProperties.class);
        Integer port = snailJobProperties.getPort();
        if (Objects.isNull(port)) {
            port = Optional.ofNullable(serverProperties.getPort()).orElse(PORT);
            snailJobProperties.setPort(port);
            SnailJobLog.LOCAL.info("snail job client port :{}", new Object[]{port});
        } else if (port.equals(RANDOM_CLIENT_PORT)) {
            PORT_LOCK.lock();
            try {
                if (snailJobProperties.getPort().equals(RANDOM_CLIENT_PORT)) {
                    port = GrpcChannel.getAvailablePort();
                    snailJobProperties.setPort(port);
                    SnailJobLog.LOCAL.info("snail job client port :{}", new Object[]{port});
                } else {
                    port = snailJobProperties.getPort();
                }
            }
            finally {
                PORT_LOCK.unlock();
            }
        }
        return port;
    }

    private static Integer getAvailablePort() {
        int port;
        while (!GrpcChannel.isPortAvailable(port = MIN_PORT + (int)(Math.random() * (double)(MAX_PORT - MIN_PORT)))) {
        }
        return port;
    }

    private static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket serverSocket = new ServerSocket();
        try {
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(port));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        serverSocket.close();
        return bl;
    }

    public static ListenableFuture<GrpcResult> sendOfUnary(String path, String body, long reqId) {
        if (channel == null) {
            return null;
        }
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        SnailJobProperties.ServerConfig serverConfig = snailJobProperties.getServer();
        if (Objects.isNull(serverConfig)) {
            SnailJobLog.LOCAL.error("snail job server config is null", new Object[0]);
            return null;
        }
        Assert.notBlank((CharSequence)snailJobProperties.getGroup(), () -> new SnailJobRemoteException("The group is null, please check if your configuration is correct."));
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put(HeadersEnum.HOST_ID.getKey(), HOST_ID);
        headersMap.put(HeadersEnum.HOST_IP.getKey(), GrpcChannel.getClientHost());
        headersMap.put(HeadersEnum.GROUP_NAME.getKey(), snailJobProperties.getGroup());
        headersMap.put(HeadersEnum.HOST_PORT.getKey(), String.valueOf(GrpcChannel.getClientPort()));
        headersMap.put(HeadersEnum.VERSION.getKey(), String.valueOf(GroupVersionCache.getVersion()));
        headersMap.put(HeadersEnum.HOST.getKey(), serverConfig.getHost());
        headersMap.put(HeadersEnum.NAMESPACE.getKey(), Optional.ofNullable(snailJobProperties.getNamespace()).orElse("764d604ec6fc45f68cd92514c40e9e1a"));
        headersMap.put(HeadersEnum.TOKEN.getKey(), Optional.ofNullable(snailJobProperties.getToken()).orElse("SJ_Wyz3dmsdbDOkDujOTSSoBjGQP1BMsVnj"));
        Metadata metadata = Metadata.newBuilder().setUri(path).putAllHeaders(headersMap).build();
        GrpcSnailJobRequest snailJobRequest = GrpcSnailJobRequest.newBuilder().setMetadata(metadata).setReqId(reqId).setBody(body).build();
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"UnaryRequest", (String)"unaryRequest")).setRequestMarshaller(ProtoUtils.marshaller((Message)GrpcSnailJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GrpcResult.getDefaultInstance())).build();
        return ClientCalls.futureUnaryCall((ClientCall)channel.newCall(methodDescriptor, CallOptions.DEFAULT), (Object)snailJobRequest);
    }

    static {
        MIN_PORT = 15000;
        MAX_PORT = 50000;
        PORT_LOCK = new ReentrantLock();
        RANDOM_CLIENT_PORT = -1;
        HOST_ID = IdUtil.getSnowflake().nextIdStr();
        PORT = Integer.parseInt(System.getProperty(SNAIL_JOB_CLIENT_PORT, String.valueOf(1789)));
        HOST = System.getProperty(SNAIL_JOB_CLIENT_HOST, NetUtil.getLocalIpStr());
    }
}

