/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobRemoteException;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;

public class NettyChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyChannel.class);
    private static Channel CHANNEL;
    private static final String SNAIL_JOB_SERVER_PORT = "snail-job.server.port";
    private static final String SNAIL_JOB_SERVER_HOST = "snail-job.server.host";
    private static final String SNAIL_JOB_CLIENT_PORT = "snail-job.port";
    private static final String SNAIL_JOB_CLIENT_HOST = "snail-job.host";
    private static final Integer MIN_PORT;
    private static final Integer MAX_PORT;
    private static final ReentrantLock PORT_LOCK;
    private static final Integer RANDOM_CLIENT_PORT;
    private static final String HOST_ID;
    private static final int PORT;
    private static final String HOST;

    private NettyChannel() {
    }

    public static int getServerPort() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getContext().getBean(SnailJobProperties.class);
        SnailJobProperties.ServerConfig serverConfig = snailJobProperties.getServer();
        String port = System.getProperty(SNAIL_JOB_SERVER_PORT);
        if (StrUtil.isBlank((CharSequence)port)) {
            System.setProperty(SNAIL_JOB_SERVER_PORT, String.valueOf(serverConfig.getPort()));
        }
        return Integer.parseInt(System.getProperty(SNAIL_JOB_SERVER_PORT));
    }

    public static String getServerHost() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        SnailJobProperties.ServerConfig serverConfig = snailJobProperties.getServer();
        String host = System.getProperty(SNAIL_JOB_SERVER_HOST);
        if (StrUtil.isBlank((CharSequence)host)) {
            System.setProperty(SNAIL_JOB_SERVER_HOST, serverConfig.getHost());
        }
        return System.getProperty(SNAIL_JOB_SERVER_HOST);
    }

    public static String getClientHost() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        String host = snailJobProperties.getHost();
        if (StrUtil.isBlank((CharSequence)host)) {
            host = HOST;
        }
        return host;
    }

    public static Integer getClientPort() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        ServerProperties serverProperties = (ServerProperties)SnailSpringContext.getBean(ServerProperties.class);
        Integer port = snailJobProperties.getPort();
        if (Objects.isNull(port)) {
            port = Optional.ofNullable(serverProperties.getPort()).orElse(PORT);
            snailJobProperties.setPort(port);
            SnailJobLog.LOCAL.info("snail job client port :{}", new Object[]{port});
        } else if (port.equals(RANDOM_CLIENT_PORT)) {
            PORT_LOCK.lock();
            try {
                if (snailJobProperties.getPort().equals(RANDOM_CLIENT_PORT)) {
                    port = NettyChannel.getAvailablePort();
                    snailJobProperties.setPort(port);
                    SnailJobLog.LOCAL.info("snail job client port :{}", new Object[]{port});
                } else {
                    port = snailJobProperties.getPort();
                }
            }
            finally {
                PORT_LOCK.unlock();
            }
        }
        return port;
    }

    private static Integer getAvailablePort() {
        int port;
        while (!NettyChannel.isPortAvailable(port = MIN_PORT + (int)(Math.random() * (double)(MAX_PORT - MIN_PORT)))) {
        }
        return port;
    }

    private static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket serverSocket = new ServerSocket();
        try {
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(port));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        serverSocket.close();
        return bl;
    }

    public static void setChannel(Channel channel) {
        CHANNEL = channel;
    }

    public static void send(HttpMethod method, String url, String body) throws InterruptedException {
        if (Objects.isNull(CHANNEL)) {
            SnailJobLog.LOCAL.error("send message but channel is null url:[{}] method:[{}] body:[{}] ", new Object[]{url, method, body});
            return;
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, url, Unpooled.wrappedBuffer((byte[])body.getBytes(StandardCharsets.UTF_8)));
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        SnailJobProperties.ServerConfig serverConfig = snailJobProperties.getServer();
        if (Objects.isNull(serverConfig)) {
            SnailJobLog.LOCAL.error("snail job server config is null", new Object[0]);
            return;
        }
        Assert.notBlank((CharSequence)snailJobProperties.getGroup(), () -> new SnailJobRemoteException("The group is null, please check if your configuration is correct."));
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)request.content().readableBytes()).set(HeadersEnum.HOST_ID.getKey(), (Object)HOST_ID).set(HeadersEnum.HOST_IP.getKey(), (Object)NettyChannel.getClientHost()).set(HeadersEnum.GROUP_NAME.getKey(), (Object)snailJobProperties.getGroup()).set(HeadersEnum.HOST_PORT.getKey(), (Object)NettyChannel.getClientPort()).set(HeadersEnum.VERSION.getKey(), (Object)GroupVersionCache.getVersion()).set(HeadersEnum.HOST.getKey(), (Object)serverConfig.getHost()).set(HeadersEnum.NAMESPACE.getKey(), (Object)Optional.ofNullable(snailJobProperties.getNamespace()).orElse("764d604ec6fc45f68cd92514c40e9e1a")).set(HeadersEnum.TOKEN.getKey(), (Object)Optional.ofNullable(snailJobProperties.getToken()).orElse("SJ_Wyz3dmsdbDOkDujOTSSoBjGQP1BMsVnj"));
        try {
            CHANNEL.writeAndFlush((Object)request).sync();
        }
        catch (Exception exception) {
            throw new SnailJobRemoteException("\u7f51\u7edc\u5f02\u5e38");
        }
    }

    static {
        MIN_PORT = 15000;
        MAX_PORT = 50000;
        PORT_LOCK = new ReentrantLock();
        RANDOM_CLIENT_PORT = -1;
        HOST_ID = IdUtil.getSnowflake().nextIdStr();
        PORT = Integer.parseInt(System.getProperty(SNAIL_JOB_CLIENT_PORT, String.valueOf(1789)));
        HOST = System.getProperty(SNAIL_JOB_CLIENT_HOST, NetUtil.getLocalIpStr());
    }
}

