/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor;

import com.aizuda.snailjob.client.job.core.dto.JobArgs;
import com.aizuda.snailjob.client.job.core.dto.MergeReduceArgs;
import com.aizuda.snailjob.client.job.core.dto.ReduceArgs;
import com.aizuda.snailjob.client.job.core.executor.AbstractMapExecutor;
import com.aizuda.snailjob.client.job.core.executor.JobContextManager;
import com.aizuda.snailjob.client.model.ExecuteResult;
import com.aizuda.snailjob.common.core.enums.MapReduceStageEnum;
import com.aizuda.snailjob.common.core.exception.SnailJobMapReduceException;
import com.aizuda.snailjob.common.core.model.JobContext;

public abstract class AbstractMapReduceExecutor
extends AbstractMapExecutor {
    @Override
    public ExecuteResult doJobExecute(JobArgs jobArgs) {
        JobContext jobContext = JobContextManager.getJobContext();
        if (jobContext.getMrStage().equals(MapReduceStageEnum.MAP.getStage())) {
            return super.doJobExecute(jobArgs);
        }
        if (jobContext.getMrStage().equals(MapReduceStageEnum.REDUCE.getStage())) {
            ReduceArgs reduceArgs = (ReduceArgs)jobArgs;
            return this.doReduceExecute(reduceArgs);
        }
        if (jobContext.getMrStage().equals(MapReduceStageEnum.MERGE_REDUCE.getStage())) {
            MergeReduceArgs reduceArgs = (MergeReduceArgs)jobArgs;
            return this.doMergeReduceExecute(reduceArgs);
        }
        throw new SnailJobMapReduceException("\u975e\u6cd5\u7684MapReduceStage");
    }

    protected abstract ExecuteResult doReduceExecute(ReduceArgs var1);

    protected abstract ExecuteResult doMergeReduceExecute(MergeReduceArgs var1);
}

