/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor;

import com.aizuda.snailjob.client.job.core.IJobExecutor;
import com.aizuda.snailjob.client.job.core.MapHandler;
import com.aizuda.snailjob.client.job.core.cache.JobExecutorInfoCache;
import com.aizuda.snailjob.client.job.core.dto.JobArgs;
import com.aizuda.snailjob.client.job.core.dto.JobExecutorInfo;
import com.aizuda.snailjob.client.job.core.dto.MapArgs;
import com.aizuda.snailjob.client.job.core.executor.AbstractJobExecutor;
import com.aizuda.snailjob.client.job.core.executor.MapInvokeHandler;
import com.aizuda.snailjob.client.model.ExecuteResult;
import com.aizuda.snailjob.common.core.exception.SnailJobMapReduceException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractMapExecutor
extends AbstractJobExecutor
implements IJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMapExecutor.class);

    @Override
    protected ExecuteResult doJobExecute(JobArgs jobArgs) {
        if (jobArgs instanceof MapArgs) {
            return this.doJobMapExecute((MapArgs)jobArgs, this.getMapHandler());
        }
        throw new SnailJobMapReduceException("For tasks that are not of type map or map reduce, please do not use the AbstractMapExecutor class.");
    }

    public abstract ExecuteResult doJobMapExecute(MapArgs var1, MapHandler var2);

    private MapHandler getMapHandler() {
        return (MapHandler)Proxy.newProxyInstance(MapHandler.class.getClassLoader(), new Class[]{MapHandler.class}, (InvocationHandler)new MapInvokeHandler());
    }

    protected ExecuteResult invokeMapExecute(MapArgs mapArgs, MapHandler mapHandler) {
        JobExecutorInfo jobExecutorInfo = JobExecutorInfoCache.get(mapArgs.getExecutorInfo());
        if (Objects.isNull(jobExecutorInfo)) {
            throw new SnailJobMapReduceException("[{}] not found", (Object)mapArgs.getExecutorInfo());
        }
        Map mapExecutorMap = Optional.ofNullable(jobExecutorInfo.getMapExecutorMap()).orElse(new HashMap());
        Method method = (Method)mapExecutorMap.get(mapArgs.getTaskName());
        if (Objects.isNull(method)) {
            throw new SnailJobMapReduceException("[{}#{}] MapTask execution method not found. Please configure the @MapExecutor annotation", new Object[]{mapArgs.getExecutorInfo(), mapArgs.getTaskName()});
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 1) {
            return (ExecuteResult)ReflectionUtils.invokeMethod((Method)method, (Object)jobExecutorInfo.getExecutor(), (Object[])new Object[]{mapArgs});
        }
        if (paramTypes.length == 2) {
            return (ExecuteResult)ReflectionUtils.invokeMethod((Method)method, (Object)jobExecutorInfo.getExecutor(), (Object[])new Object[]{mapArgs, mapHandler});
        }
        throw new SnailJobMapReduceException("Executor for [{}] not found", (Object)mapArgs.getTaskName());
    }
}

