/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.alarm.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.attribute.LarkAttribute;
import com.aizuda.snailjob.common.core.alarm.strategy.AbstractAlarm;
import com.aizuda.snailjob.common.core.enums.AlarmTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LarkAlarm
extends AbstractAlarm<AlarmContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LarkAlarm.class);
    public static final String AT_LABEL = "<at id={0}></at>";

    @Override
    public Integer getAlarmType() {
        return AlarmTypeEnum.LARK.getValue();
    }

    @Override
    public boolean syncSendMessage(AlarmContext context) {
        try {
            LarkAttribute larkAttribute = JsonUtil.parseObject(context.getNotifyAttribute(), LarkAttribute.class);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("header", this.buildHeader(context.getTitle()));
            map.put("elements", this.buildElements(context.getText(), larkAttribute.getAts()));
            LarkMessage builder = LarkMessage.builder().msgType("interactive").card(map).build();
            HttpRequest post = HttpUtil.createPost((String)larkAttribute.getWebhookUrl());
            HttpRequest request = post.body(JsonUtil.toJsonString(builder), ContentType.JSON.toString());
            HttpResponse execute = request.execute();
            if (execute.isOk()) {
                return true;
            }
            SnailJobLog.LOCAL.error("\u53d1\u9001lark\u6d88\u606f\u5931\u8d25:{}", new Object[]{execute.body()});
            return false;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001lark\u6d88\u606f\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private List buildElements(String text, List<String> ats) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tag", "markdown");
        map.put("content", this.getAtText(text, ats));
        return Collections.singletonList(map);
    }

    private Map<String, Object> buildHeader(String title) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("template", "red");
        HashMap<String, String> titleMap = new HashMap<String, String>();
        titleMap.put("content", title);
        titleMap.put("tag", "plain_text");
        map.put("title", titleMap);
        return map;
    }

    @Override
    public boolean asyncSendMessage(List<AlarmContext> notifierElements) {
        for (AlarmContext notifierElement : notifierElements) {
            this.asyncSendMessage(notifierElement);
        }
        return Boolean.TRUE;
    }

    public String getAtText(String text, List<String> ats) {
        if (CollUtil.isEmpty(ats)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(text);
        if (ats.stream().map(String::toLowerCase).anyMatch("all"::equals)) {
            sb.append(MessageFormat.format(AT_LABEL, "all"));
        } else {
            ats.stream().filter(CharSequenceUtil::isNotBlank).forEach(at -> sb.append(MessageFormat.format(AT_LABEL, at)));
        }
        return sb.toString();
    }

    private static class LarkMessage {
        @JsonProperty(value="msg_type")
        private String msgType;
        private Map<String, Object> card;

        @Generated
        LarkMessage(String msgType, Map<String, Object> card) {
            this.msgType = msgType;
            this.card = card;
        }

        @Generated
        public static LarkMessageBuilder builder() {
            return new LarkMessageBuilder();
        }

        @Generated
        public String getMsgType() {
            return this.msgType;
        }

        @Generated
        public Map<String, Object> getCard() {
            return this.card;
        }

        @JsonProperty(value="msg_type")
        @Generated
        public void setMsgType(String msgType) {
            this.msgType = msgType;
        }

        @Generated
        public void setCard(Map<String, Object> card) {
            this.card = card;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LarkMessage)) {
                return false;
            }
            LarkMessage other = (LarkMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgType = this.getMsgType();
            String other$msgType = other.getMsgType();
            if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
                return false;
            }
            Map<String, Object> this$card = this.getCard();
            Map<String, Object> other$card = other.getCard();
            return !(this$card == null ? other$card != null : !((Object)this$card).equals(other$card));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LarkMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgType = this.getMsgType();
            result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
            Map<String, Object> $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LarkAlarm.LarkMessage(msgType=" + this.getMsgType() + ", card=" + this.getCard() + ")";
        }

        @Generated
        public static class LarkMessageBuilder {
            @Generated
            private String msgType;
            @Generated
            private Map<String, Object> card;

            @Generated
            LarkMessageBuilder() {
            }

            @JsonProperty(value="msg_type")
            @Generated
            public LarkMessageBuilder msgType(String msgType) {
                this.msgType = msgType;
                return this;
            }

            @Generated
            public LarkMessageBuilder card(Map<String, Object> card) {
                this.card = card;
                return this;
            }

            @Generated
            public LarkMessage build() {
                return new LarkMessage(this.msgType, this.card);
            }

            @Generated
            public String toString() {
                return "LarkAlarm.LarkMessage.LarkMessageBuilder(msgType=" + this.msgType + ", card=" + this.card + ")";
            }
        }
    }
}

