/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.enums;

import lombok.Generated;

public enum RetryOperationReasonEnum {
    NONE(0, ""),
    TASK_EXECUTION_TIMEOUT(1, "Task execution timeout"),
    NOT_CLIENT(2, "No client nodes"),
    RETRY_SUSPEND(3, "Retry paused"),
    RETRY_TASK_DISCARD(4, "Task discarded"),
    RETRY_TASK_OVERLAY(5, "Task overridden"),
    TASK_EXECUTION_ERROR(6, "Unexpected exception occurred during task execution"),
    MANNER_STOP(7, "Manual stop"),
    NOT_RUNNING_RETRY(8, "Current retry not running"),
    SCENE_CLOSED(9, "Current scene closed"),
    RETRY_FAIL(10, "Retry failed"),
    CLIENT_TRIGGER_RETRY_STOP(11, "Client triggered task stop");

    private final int reason;
    private final String desc;

    public static RetryOperationReasonEnum of(Integer operationReason) {
        if (operationReason == null) {
            return NONE;
        }
        for (RetryOperationReasonEnum sceneEnum : RetryOperationReasonEnum.values()) {
            if (sceneEnum.getReason() != operationReason.intValue()) continue;
            return sceneEnum;
        }
        return NONE;
    }

    @Generated
    private RetryOperationReasonEnum(int reason, String desc) {
        this.reason = reason;
        this.desc = desc;
    }

    @Generated
    public int getReason() {
        return this.reason;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }
}

