/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.generator.id;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.enums.IdGeneratorModeEnum;
import com.aizuda.snailjob.server.common.generator.id.IdGenerator;
import com.aizuda.snailjob.server.common.generator.id.Segment;
import com.aizuda.snailjob.server.common.generator.id.SegmentBuffer;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SequenceAllocMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.SequenceAlloc;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated
public class SegmentIdGenerator
implements IdGenerator,
Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentIdGenerator.class);
    private static final long EXCEPTION_ID_IDCACHE_INIT_FALSE = -1L;
    private static final long EXCEPTION_ID_KEY_NOT_EXISTS = -2L;
    private static final long EXCEPTION_ID_TWO_SEGMENTS_ARE_NULL = -3L;
    private static final int MAX_STEP = 1000000;
    private static final long SEGMENT_DURATION = 900000L;
    private final ThreadPoolExecutor service = new ThreadPoolExecutor(5, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(5000), new UpdateThreadFactory());
    private volatile boolean initOK = false;
    private final Map<Pair<String, String>, SegmentBuffer> cache = new ConcurrentHashMap<Pair<String, String>, SegmentBuffer>();
    @Autowired
    private SequenceAllocMapper sequenceAllocMapper;

    @Override
    public void start() {
        SnailJobLog.LOCAL.info("SegmentIdGenerator start", new Object[0]);
        this.updateCacheFromDb();
        this.initOK = true;
        this.updateCacheFromDbAtEveryMinute();
        SnailJobLog.LOCAL.info("SegmentIdGenerator start end", new Object[0]);
    }

    @Override
    public void close() {
        SnailJobLog.LOCAL.info("SegmentIdGenerator close", new Object[0]);
    }

    private void updateCacheFromDbAtEveryMinute() {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("check-id-cache-thread");
            t.setDaemon(true);
            return t;
        });
        service.scheduleWithFixedDelay(this::updateCacheFromDb, 60L, 60L, TimeUnit.SECONDS);
    }

    private void updateCacheFromDb() {
        try {
            List sequenceAllocs = this.sequenceAllocMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SequenceAlloc::getGroupName, SequenceAlloc::getNamespaceId}));
            if (CollUtil.isEmpty((Collection)sequenceAllocs)) {
                return;
            }
            List dbTags = StreamUtils.toList((Collection)sequenceAllocs, sequenceAlloc -> Pair.of((Object)sequenceAlloc.getGroupName(), (Object)sequenceAlloc.getNamespaceId()));
            ArrayList<Pair<String, String>> cacheTags = new ArrayList<Pair<String, String>>(this.cache.keySet());
            HashSet insertTagsSet = new HashSet(dbTags);
            HashSet<Pair<String, String>> removeTagsSet = new HashSet<Pair<String, String>>(cacheTags);
            for (int i = 0; i < cacheTags.size(); ++i) {
                Pair pair = (Pair)cacheTags.get(i);
                insertTagsSet.remove(pair);
            }
            for (Pair pair : insertTagsSet) {
                SegmentBuffer buffer = new SegmentBuffer();
                buffer.setKey((Pair<String, String>)pair);
                Segment segment = buffer.getCurrent();
                segment.setValue(new AtomicLong(0L));
                segment.setMax(0L);
                segment.setStep(0);
                this.cache.put((Pair<String, String>)pair, buffer);
                SnailJobLog.LOCAL.debug("Add tag {} from db to IdCache, SegmentBuffer {}", new Object[]{pair, buffer});
            }
            for (int i = 0; i < dbTags.size(); ++i) {
                Pair pair = (Pair)dbTags.get(i);
                removeTagsSet.remove(pair);
            }
            for (Pair pair : removeTagsSet) {
                this.cache.remove(pair);
                SnailJobLog.LOCAL.debug("Remove tag {} from IdCache", new Object[]{pair});
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("update cache from db exception", new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String groupName, String namespaceId) {
        if (!this.initOK) {
            return Long.toString(-1L);
        }
        Pair key = Pair.of((Object)groupName, (Object)namespaceId);
        if (this.cache.containsKey(key)) {
            SegmentBuffer buffer = this.cache.get(key);
            if (!buffer.isInitOk()) {
                SegmentBuffer segmentBuffer = buffer;
                synchronized (segmentBuffer) {
                    if (!buffer.isInitOk()) {
                        try {
                            this.updateSegmentFromDb((Pair<String, String>)key, buffer.getCurrent());
                            SnailJobLog.LOCAL.debug("Init buffer. Update key {} {} from db", new Object[]{key, buffer.getCurrent()});
                            buffer.setInitOk(true);
                        }
                        catch (Exception e) {
                            SnailJobLog.LOCAL.error("Init buffer {} exception", new Object[]{buffer.getCurrent(), e});
                        }
                    }
                }
            }
            return this.getIdFromSegmentBuffer(this.cache.get(key));
        }
        return Long.toString(-2L);
    }

    public void updateSegmentFromDb(Pair<String, String> key, Segment segment) {
        SequenceAlloc sequenceAlloc;
        SegmentBuffer buffer = segment.getBuffer();
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().setSql("max_id = max_id + step", new Object[0])).set(SequenceAlloc::getUpdateDt, (Object)new Date())).eq(SequenceAlloc::getGroupName, key.getKey())).eq(SequenceAlloc::getNamespaceId, key.getValue());
        if (!buffer.isInitOk()) {
            this.sequenceAllocMapper.update((Wrapper)wrapper);
            sequenceAlloc = (SequenceAlloc)this.sequenceAllocMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SequenceAlloc::getGroupName, key.getKey())).eq(SequenceAlloc::getNamespaceId, key.getValue()));
            buffer.setStep(sequenceAlloc.getStep());
            buffer.setMinStep(sequenceAlloc.getStep());
        } else if (buffer.getUpdateTimestamp() == 0L) {
            this.sequenceAllocMapper.update((Wrapper)wrapper);
            sequenceAlloc = (SequenceAlloc)this.sequenceAllocMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SequenceAlloc::getGroupName, key.getKey())).eq(SequenceAlloc::getNamespaceId, key.getValue()));
            buffer.setUpdateTimestamp(System.currentTimeMillis());
            buffer.setStep(sequenceAlloc.getStep());
            buffer.setMinStep(sequenceAlloc.getStep());
        } else {
            long duration = System.currentTimeMillis() - buffer.getUpdateTimestamp();
            int nextStep = buffer.getStep();
            if (duration < 900000L) {
                if (nextStep * 2 <= 1000000) {
                    nextStep *= 2;
                }
            } else if (duration >= 1800000L) {
                nextStep = nextStep / 2 >= buffer.getMinStep() ? nextStep / 2 : nextStep;
            }
            SnailJobLog.LOCAL.debug("leafKey[{}], step[{}], duration[{}mins], nextStep[{}]", new Object[]{key, buffer.getStep(), String.format("%.2f", (double)duration / 60000.0), nextStep});
            LambdaUpdateWrapper wrapper1 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().setSql("max_id = max_id + " + nextStep, new Object[0])).set(SequenceAlloc::getUpdateDt, (Object)new Date())).eq(SequenceAlloc::getGroupName, key.getKey())).eq(SequenceAlloc::getNamespaceId, key.getValue());
            this.sequenceAllocMapper.update((Wrapper)wrapper1);
            sequenceAlloc = (SequenceAlloc)this.sequenceAllocMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SequenceAlloc::getGroupName, key.getKey())).eq(SequenceAlloc::getNamespaceId, key.getValue()));
            buffer.setUpdateTimestamp(System.currentTimeMillis());
            buffer.setStep(nextStep);
            buffer.setMinStep(sequenceAlloc.getStep());
        }
        long value = sequenceAlloc.getMaxId() - (long)buffer.getStep();
        segment.getValue().set(value);
        segment.setMax(sequenceAlloc.getMaxId());
        segment.setStep(buffer.getStep());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdFromSegmentBuffer(SegmentBuffer buffer) {
        while (true) {
            long value;
            Segment segment;
            buffer.rLock().lock();
            try {
                segment = buffer.getCurrent();
                if (!buffer.isNextReady() && (double)segment.getIdle() < 0.9 * (double)segment.getStep() && buffer.getThreadRunning().compareAndSet(false, true)) {
                    this.service.execute(() -> {
                        Segment next = buffer.getSegments()[buffer.nextPos()];
                        boolean updateOk = false;
                        try {
                            this.updateSegmentFromDb(buffer.getKey(), next);
                            updateOk = true;
                            SnailJobLog.LOCAL.debug("update segment {} from db {}", new Object[]{buffer.getKey(), next});
                        }
                        catch (Exception e) {
                            SnailJobLog.LOCAL.warn(String.valueOf(buffer.getKey()) + " updateSegmentFromDb exception", new Object[]{e});
                        }
                        finally {
                            if (updateOk) {
                                buffer.wLock().lock();
                                buffer.setNextReady(true);
                                buffer.getThreadRunning().set(false);
                                buffer.wLock().unlock();
                            } else {
                                buffer.getThreadRunning().set(false);
                            }
                        }
                    });
                }
                if ((value = segment.getValue().getAndIncrement()) < segment.getMax()) {
                    String string = Long.toString(value);
                    return string;
                }
            }
            finally {
                buffer.rLock().unlock();
            }
            this.waitAndSleep(buffer);
            buffer.wLock().lock();
            try {
                segment = buffer.getCurrent();
                value = segment.getValue().getAndIncrement();
                if (value < segment.getMax()) {
                    String string = Long.toString(value);
                    return string;
                }
                if (buffer.isNextReady()) {
                    buffer.switchPos();
                    buffer.setNextReady(false);
                    continue;
                }
                SnailJobLog.LOCAL.error("Both two segments in {} are not ready!", new Object[]{buffer});
                String string = Long.toString(-3L);
                return string;
            }
            finally {
                buffer.wLock().unlock();
                continue;
            }
            break;
        }
    }

    private void waitAndSleep(SegmentBuffer buffer) {
        int roll = 0;
        while (buffer.getThreadRunning().get()) {
            if (++roll <= 10000) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            catch (InterruptedException e) {
                SnailJobLog.LOCAL.warn("Thread {} Interrupted", new Object[]{Thread.currentThread().getName()});
            }
            break;
        }
    }

    @Override
    public boolean supports(int mode) {
        return IdGeneratorModeEnum.SEGMENT.getMode() == mode;
    }

    @Override
    public String idGenerator(String groupName, String namespaceId) {
        String time = DateUtils.format(DateUtils.toNowLocalDateTime(), DateUtils.PURE_DATETIME_MS_PATTERN);
        return time.concat(this.get(groupName, namespaceId));
    }

    public static class UpdateThreadFactory
    implements ThreadFactory {
        private static int threadInitNumber = 0;

        private static synchronized int nextThreadNum() {
            return threadInitNumber++;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Thread-Segment-Update-" + UpdateThreadFactory.nextThreadNum());
        }
    }
}

