/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.register;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.Register;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.register.RegisterContext;
import com.aizuda.snailjob.server.common.triple.Pair;
import com.aizuda.snailjob.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;

public abstract class AbstractRegister
implements Register,
Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRegister.class);
    @Autowired
    protected ServerNodeMapper serverNodeMapper;

    @Override
    public boolean register(RegisterContext context) {
        this.beforeProcessor(context);
        ServerNode serverNode = this.initServerNode(context);
        boolean result = this.doRegister(context, serverNode);
        this.afterProcessor(serverNode);
        return result;
    }

    protected abstract void afterProcessor(ServerNode var1);

    protected void refreshExpireAt(List<ServerNode> serverNodes) {
        if (CollUtil.isEmpty(serverNodes)) {
            return;
        }
        HashSet hostIds = Sets.newHashSet();
        HashSet hostIps = Sets.newHashSet();
        for (ServerNode serverNode2 : serverNodes) {
            serverNode2.setExpireAt(this.getExpireAt());
            hostIds.add(serverNode2.getHostId());
            hostIps.add(serverNode2.getHostIp());
        }
        List dbServerNodes = this.serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ServerNode::getHostIp, ServerNode::getHostId}).in(ServerNode::getHostId, (Collection)hostIds)).in(ServerNode::getHostIp, (Collection)hostIps));
        ArrayList insertDBs = Lists.newArrayList();
        ArrayList updateDBs = Lists.newArrayList();
        Set pairs = dbServerNodes.stream().map(serverNode -> Pair.of(serverNode.getHostId(), serverNode.getHostIp())).collect(Collectors.toSet());
        HashSet existed = Sets.newHashSet();
        for (ServerNode serverNode3 : serverNodes) {
            Pair<String, String> pair = Pair.of(serverNode3.getHostId(), serverNode3.getHostIp());
            if (existed.contains(pair)) continue;
            if (pairs.contains(pair)) {
                updateDBs.add(serverNode3);
            } else {
                insertDBs.add(serverNode3);
            }
            existed.add(pair);
        }
        try {
            if (CollUtil.isNotEmpty((Collection)updateDBs)) {
                this.serverNodeMapper.updateBatchExpireAt((List)updateDBs);
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u7eed\u79df\u5931\u8d25", new Object[]{e});
        }
        try {
            if (CollUtil.isNotEmpty((Collection)insertDBs)) {
                this.serverNodeMapper.insertBatch((List)insertDBs);
            }
        }
        catch (DuplicateKeyException e) {
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u6ce8\u518c\u8282\u70b9\u5931\u8d25", new Object[]{e});
        }
        for (ServerNode serverNode3 : serverNodes) {
            CacheRegisterTable.refreshExpireAt(serverNode3);
        }
    }

    protected abstract void beforeProcessor(RegisterContext var1);

    protected ServerNode initServerNode(RegisterContext context) {
        ServerNode serverNode = new ServerNode();
        serverNode.setHostId(context.getHostId());
        serverNode.setHostIp(context.getHostIp());
        serverNode.setNamespaceId(context.getNamespaceId());
        serverNode.setGroupName(context.getGroupName());
        serverNode.setHostPort(context.getHostPort());
        serverNode.setNodeType(this.getNodeType());
        serverNode.setCreateDt(LocalDateTime.now());
        serverNode.setExtAttrs(context.getExtAttrs());
        return serverNode;
    }

    protected abstract LocalDateTime getExpireAt();

    protected abstract boolean doRegister(RegisterContext var1, ServerNode var2);

    protected abstract Integer getNodeType();
}

