/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.alarm.listener;

import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.AlarmInfoConverter;
import com.aizuda.snailjob.server.common.alarm.AbstractJobAlarm;
import com.aizuda.snailjob.server.common.dto.JobAlarmInfo;
import com.aizuda.snailjob.server.common.dto.NotifyConfigInfo;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.support.alarm.event.JobTaskFailAlarmEvent;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class JobTaskFailAlarmListener
extends AbstractJobAlarm<JobTaskFailAlarmEvent> {
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final LinkedBlockingQueue<Long> queue = new LinkedBlockingQueue(1000);
    private static final String MESSAGES_FORMATTER = "   <font face=\u5fae\u8f6f\u96c5\u9ed1 color=#ff0000 size=4>{}\u73af\u5883 Job\u4efb\u52a1\u6267\u884c\u5931\u8d25</font> \n            > \u7a7a\u95f4ID:{}  \n            > \u7ec4\u540d\u79f0:{}  \n            > \u4efb\u52a1\u540d\u79f0:{}  \n            > \u6267\u884c\u5668\u540d\u79f0:{}  \n            > \u5931\u8d25\u539f\u56e0:{}  \n            > \u65b9\u6cd5\u53c2\u6570:{}  \n            > \u65f6\u95f4:{};\n";

    protected List<JobAlarmInfo> poll() throws InterruptedException {
        Long jobTaskBatchId = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        if (Objects.isNull(jobTaskBatchId)) {
            return Lists.newArrayList();
        }
        ArrayList jobTaskBatchIds = Lists.newArrayList((Object[])new Long[]{jobTaskBatchId});
        this.queue.drainTo(jobTaskBatchIds, 200);
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"batch.id", (Collection)jobTaskBatchIds)).eq((Object)"batch.deleted", (Object)0);
        List jobTaskBatchList = this.jobTaskBatchMapper.selectJobBatchListByIds((Wrapper)wrapper);
        return AlarmInfoConverter.INSTANCE.toJobAlarmInfos(jobTaskBatchList);
    }

    protected AlarmContext buildAlarmContext(JobAlarmInfo alarmDTO, NotifyConfigInfo notifyConfig) {
        String desc = JobOperationReasonEnum.getByReason((Integer)alarmDTO.getOperationReason()).getDesc();
        return AlarmContext.build().text(MESSAGES_FORMATTER, new Object[]{EnvironmentUtils.getActiveProfile(), alarmDTO.getNamespaceId(), alarmDTO.getGroupName(), alarmDTO.getJobName(), alarmDTO.getExecutorInfo(), desc, alarmDTO.getArgsStr(), DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN)}).title("{}\u73af\u5883 JOB\u4efb\u52a1\u5931\u8d25", new Object[]{EnvironmentUtils.getActiveProfile()});
    }

    protected void startLog() {
        SnailJobLog.LOCAL.info("JobTaskFailAlarmListener started", new Object[0]);
    }

    protected int getNotifyScene() {
        return JobNotifySceneEnum.JOB_TASK_ERROR.getNotifyScene();
    }

    protected List<SyetemTaskTypeEnum> getSystemTaskType() {
        return Lists.newArrayList((Object[])new SyetemTaskTypeEnum[]{SyetemTaskTypeEnum.JOB});
    }

    @TransactionalEventListener(fallbackExecution=true, phase=TransactionPhase.AFTER_COMPLETION)
    public void doOnApplicationEvent(JobTaskFailAlarmEvent event) {
        if (!this.queue.offer(event.getJobTaskBatchId())) {
            SnailJobLog.LOCAL.warn("JOB\u4efb\u52a1\u6267\u884c\u5931\u8d25\u544a\u8b66\u961f\u5217\u5df2\u6ee1", new Object[0]);
        }
    }

    public JobTaskFailAlarmListener(JobTaskBatchMapper jobTaskBatchMapper) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
    }
}

